#title: 匿名对象
#index:0,1
#author:zozoh(zozohtnt@gmail.com)

--------------------------------------------------------------------------------------------------------
鸭子法则

	{*如果它走路像鸭子，说话像鸭子，样子像鸭子，叫声也像鸭子，那它就是一只鸭子。}
	
	对于 Nutz Ioc 来说，它面对的配置文件就是层层嵌套的 "名值对集合"，或者说是 Map 集合。
	事实上，它是先把整个配置文件解析成 Map 再做判断的。
	
	如果一个 Map 仅包括如下的键，则被认为是一个注入对象：
	
	 || {*type}        	|| {#080; 对象类型} ||
	 || {*singleton}   	|| {#080; 是否单例} ||
	 || {*scope}       	|| {#080; 生命周期范围} ||
	 || {*events}		|| {#080; 监听事件} ||
	 || {*args}			|| {#080; 构造函数参数} ||
	 || {*fields}		|| {#080; 字段设定} ||
	
	否则，这个 Map 被认为，是在声明对象的每个字段。

--------------------------------------------------------------------------------------------------------
匿名对象
	
	如果，一个字段的值就是这样一个 “鸭子 Map” 呢？ 那么，自然会被认为是另外一个对象。这个
	对象没有名字，你不能通过 Ioc 接口直接获得，它隐藏在某个对象的某个字段里面。所以我们
	称这个对象为 {*匿名对象}
	
	匿名对象，没有所谓的单例，你声明了 singleton: true 也没有用。如果它的宿主是单例，它自
	然也只会被创建一次。否则，每次宿主被创建的时候，它都会被创建。
	
	JSON 配置文件：
		{{{
		var ioc = {
			xb : {
				name : 'XiaoBai',
				// 请注意，在这里， friend 字段，直接声明了另外一个对象
				friend : {
					type : 'nutz.demo.ioc.book.Pet',
					fields : {
						name : 'XiaoHei'
					}
				}
			}
		}
		}}}
	
	调用代码
		{{{
		Ioc ioc = new NutIoc(new JsonLoader("nutz/demo/ioc/book/inner.js"));
		Pet pet = ioc.get(Pet.class, "xb");
		System.out.println(pet.getFriend().getName());
		}}}
		
	控制台输出
		{{{
		XiaoHei
		}}}