#title: 日志
#index:0,1
#author:zozoh(zozohtnt@gmail.com)
#author:sunonfire(sunonfire@gmail.com)
#author:wendal(wendal1985@gmail.com)
--------------------------------------------------------------------------------------------------------
为什么要自己写一个 Log?
	首先，我们没有从头实现一个日志，我们不过是 {*适配} 日志。我们适配了 log4j 。但是为什么呢?
	为什么不直接依赖 slf4j 呢?
	
	我必须要在这里重申一下 [../nutz_preface.man Nutz 框架的目标]：
	
	 * 尽量让程序员在 {#00F;*设立开发环境} 以及 {#00F;*部署应用} 的时候获得最佳的体验
	
	如果你下载了 Nutz 的 jar，满心欢喜的加到你的项目里，然后，运行你的项目，你会发现从 Nutz.jar 里会迅速抛出
	一个异常。经过一番查阅，你发现你不得不访问 slf4j 的网站，下载它的 jar 包，然后再加入自己的项目里...
	
	{*你会因此而很高兴吗？}
	
	........
	
	不不，起码我不会高兴。 :(
	
	如果这个功能特别复杂，以至于我们没有能力做到很好，我们肯定会毫不犹豫的依赖其他的 jar 包的。比如 1.a.23
	之前，我们依赖了 [http://www.javassist.org javassist]， 1.a.24 我们包括了 [http://asm.ow2.org ASM]。
	
	另外一个原因：随着 Nutz 使用的人越来越多，如果它依赖了过多的  Jar 包，便会导致人们更多的下载行为，从而浪费不必
	要的带宽，耗费更多的电能，从而让这个地球排放更多的温室气体，厄尔尼诺现象加剧，北极融化，珍稀物种灭绝，农作物
	减产，粮食供应紧张，不利于喝血社会，不能体现带三个婊的以德治国的精神。
	
	.
	
	..
	
	...
	
	....
	
	.....
	
	......
	
	{#CCC;/好吧，我承认，我上面说的统统是狡辩，根本原因不过是因为手痒痒。而且我揭发：实际上这个模块代码都是} \
	[http://myblog.sunfarms.net {#CCC;/wendal}] {#CCC;/和 Sunonfire 写的，我其实不过是出来打酱油的 ... }

--------------------------------------------------------------------------------------------------------
如何使用日志
	Nutz Log的基本用法和常见的log4j等工具没什么不同。比如：
	{{{
	public class MyClass {
		private static final Log log = Logs.getLog(MyClass.class);

		public void myFuncion() {
			if (log.isDebugEnabled())
				log.debug("I am debug message");
		}
	}
	}}}
	
	Nutz.Log 使用了[plugin.man 插件技术]，其中优先级依次为：
	 # Log4j --> 通过log4j-over-slf4j桥,你可以将其拓展到其他log框架,如logback
	 # System.out | System.err
	
	它们可以使用的条件是：
	 * Log4j
		# 如果能够加载类 {*org.apache.log4j.Logger}，则认为可用;
	
	 * System.out | System.err
	 	# 默认永远可用

--------------------------------------------------------------------------------------------------------	
让 Nutz 输出日志
	以 log4j 为例 （因为我就对这个熟），你需要：
	
	 * 在你的项目里部署某一个 Log4j 的 jar 包，推荐 Log4j 1.2.12 或更新版本
		 * Log4j 1.2.11及之前的版本不支持 Trace,自动转为使用Debug级别来记录.
	 * 在项目的 CLASSPATH 根目录部署 log4j.properties
	 * 将 log4j.category.org.nutz 基本设成 DEBUG，你就能看到 Nutz 框架详细的 Log
		{{{
		log4j.category.org.nutz=DEBUG, A1
		 
		log4j.appender.A1=org.apache.log4j.ConsoleAppender
		log4j.appender.A1.layout=org.apache.log4j.PatternLayout
		log4j.appender.A1.layout.ConversionPattern=%d [%t] %-5p %c - %m%n
		}}}
	 * 你可以分别控制 Dao, Ioc 和 Mvc:
		 * category.org.nutz.dao=DEBUG
		 * category.org.nutz.ioc=DEBUG
		 * category.org.nutz.mvc=DEBUG
		 
--------------------------------------------------------------------------------------------------------
什么都不配置呢?
   Nutz在你没有配置任何Log时,一样工作得很好. 下面是默认行为:
   
    * 输出到System.err/out
    * 默认日志等级为 DEBUG