#title: 写在前面的话
#verifier:Xiaofeng.Fu(hilliate@gmail.com)
#author: zozoh(zozohtnt@gmail.com)

<logo.png>
--------------------------------------------------------------------------------------------------------
Java 为什么不能是一门敏捷的语言呢？

	起码 Java 是一门优美的编程语言，经过10多年的发展，它几乎已经被应用到了任何地方，在高端的企业服务器上，
	手持设备的芯片里，车载设备，智能家电甚至火星车上。在功能上，它广泛的涉足到了软件应用的各个领域，现在，
	它开始向桌面和图像处理方面频频发力。 从历史上看它是一门成熟的语言，从现在来看，它是世界上使用最广泛的
	语言，从将来看，它是最有前途的语言（现在它依然充满了活力和创新）。

	但是，在越来越流行的 Web 开发领域， Java 似乎逐渐露出了疲态。是的，脚本语言们卷起了一场热潮，似乎已经
	快可以用“革命”两个字来形容了。而Java，被“{_脚本小子们}”诟病最多的便是 {#F00;*低下的开发效率}。
	
	{#00A;*但是，真的是这样的吗？}

	从本质上来说， Java 语言本身为程序员提供的帮助只有两点，一是语言的语法，二是内置的类库。 现在
	从事 Web 开发，大多是采用第三方的类库（或者说是框架），比如流行的 SSH。 所谓 Java 在
	 Web 开发的低效，不妨这样说比较贴切一些: {#F80;*采用第三方类库进行开发比较低效}。

	为了证明这一点，我写作了 Nutz， 它是一组轻便小型的框架的集合， 各个部分可以被独立使用。 而 Nutz 的目标
	就是
	
	{#F00;* 在力所能及的情况下，最大限度的提高Web开发人员的生产力}。

	是的，提高生产力是这个框架唯一的目标。 就像 Java 设计之初，考虑最多的是程序员的易用性和运行时效率
	的权衡， Nutz 也是这样。希望通过 Nutz， Java 的开发人员可以获得更快的开发速度，更少的代码量，并且这些
	以不损害运行时效率为前提。
--------------------------------------------------------------------------------------------------------
Nutz 可以做什么？
	
	 * Dao -- 针对 {*JDBC} 的薄封装，事务模板，无缓存
	 * Ioc -- JSON 风格的配置文件，声明时切片支持
	 * Mvc -- 注解风格的配置，内置多文件上传功能
	 * Json -- 解析和渲染
	 * Castors -- Java 对象类型转换
	 * Lang -- 更简洁的 Java 函数以及更丰富的反射支持
	 * Aop -- 轻便快速的切面编程支持
	 * Plugin -- 轻便的插件机制
	 * Resource -- 资源扫描

	 它所有的功能均不依赖第三方 jar 包

	 这就意味着：
	  * 如果一个 Web 应用，你在 WEB-INF/lib 下只 需要放置一个 nutz.jar 就够了
	  * 当然你要使用连接池，数据库驱动等功能，还需要自行添置 jar 包。

--------------------------------------------------------------------------------------------------------
Nutz 为谁而设计？

	 * 如果你觉得 Hibernate 控制比较繁琐，iBatis 编写SQL又比较麻烦，{#00F;*Nutz.Dao} 专为你设计。
	 * 如果你觉得在多个服务器部署或者修改 Spring 配置文件很麻烦，{#00F;*Nutz.Ioc} 专为你设计
	 * 如果你觉得直接写 XML 配置文件很麻烦，可视化编辑器又没控制感，{#00F;*Nutz.Mvc} 专为你设计
	 * 如果你觉得 JSON 转换很麻烦（要写超过一行以上的代码），{#00F;*Nutz.Json} 专为你设计
	 * 如果你觉得 Java 语法不如 Ruby 便捷， Nutz.Castor 以及 {#00F;*Nutz.Lang} 专为你设计
	 * 如果你以前根本没接触过 SSH ，只使用 JDBC 编程， 整个 {*Nutz} 专门为你设计
--------------------------------------------------------------------------------------------------------
Nutz 的质量
	
	截至到现在为止，Nutz 的 JUnit 用例覆盖率大概是这样的
	
	<emma.png>
	
	并且这个数字还在不断增加。
	
	在一个功能告一段落以后，我通常会花1－2个晚上在一边咂着廉价的红酒一边颇有成就感的书写JUnit测试。
	通常我会用 JUnit 把我自己击溃，紧接着的那几天我都努力让那个该死红条变绿，之后，又想方设法写出
	新的Junit测试试图让它再度变红。并且我还要保证所做的修改不能让代码膨胀，这的确让我死掉了不少脑
	细胞。这些测试中，不仅涵盖各种功能上的测试，也涵盖了一些跨越线程的测试。在以后，我会针对代码执
	行的效率加入一些新的测试。
	
	我能保证的就是Nutz的代码是小巧的，以及通过尽可能多的 JUnit 测试。但是所有我能做的也就只是
	这些了，找出剩下的那些代码上的缺陷，就应该交给 Nutz 第一批“小白”们了。“小白”们，加油！我
	支持你们...
	
	{#AAA;/ 小白： 是小白鼠的简称。小白鼠是实验室的最爱，实验室是产生新东西的地方。}
--------------------------------------------------------------------------------------------------------
Nutz 的未来
	
	Nutz 是一个新兴的开源项目
	
	{*它没有过去，只有未来}
	
	我可以保证，在未来，Nutz 的代码 {#F00;*绝对不会膨胀}。 所有的功能设计的出发点就是最大限度给予程序员实惠。
--------------------------------------------------------------------------------------------------------
你完全可以让这个项目变得更加美好

	 * [http://xiaofeng.javaeye.com/blog/549410 不编写代码，你可以能为这个项目做很多事情] @[http://xiaofeng.javaeye.com hilliate]
	 * 你可以随时 [https://github.com/nutzam/nutz/issues/new 提交你发现的问题]
	 * 任何人 用 任何方式 => 指出 Nutz 的缺陷，都是被欢迎的
	 * 如果你想成为 Nutz Committers 中的一员，请 [committer/be_committer.man 阅读这里]
--------------------------------------------------------------------------------------------------------
我使用的时候如果出现问题怎么办？

	 # 加入 [http://groups.google.at/group/nutzam 讨论区]，讨论组一般总是有人在线，你的问题会很快得到响应
	 # 加入 {*GTalk 聊天群} -- 感谢 {*Van} {#999999;/ 添加帐号 nutzam@chatterous.com 为好友，然后发送 `@join` 指令}
         * 或者访问 [http://www.chatterous.com/nutzam/]
	 # 还有新浪微群
		 # [http://q.t.sina.com.cn/128323 Nutz 在微笑]
	 # 还有豆瓣小组
		 # [http://www.douban.com/group/339199/ Nutz 的微笑]
	 # 或者加入 QQ 群
		 * [http://qun.qq.com/air/#58444676 Nutz & XBlink （58444676 超级群）] -- 感谢 {*E-Hunter} 的支持  
		 * [http://qun.qq.com/#jointhegroup/gid/60504323 Nutz在微笑 （60504323）超级群] -- 感谢 {*milk cat!} 和 {*yanick} 的支持  
		 * [http://qun.qq.com/#jointhegroup/gid/68428921 Nutz ② 群 （68428921）超级群] -- 感谢 {*c.A} 的支持  
	 
	 考虑到，现在这个特殊时期，[https://groups.google.com/group/nutzam 讨论区] 即使用 https 也会不时被墙。
	 所以你还可以给[http://code.google.com/p/nutz/people/list 项目成员]直接发信
	 * 一般情况下，你的问题都会得到答复
	 * 但是你必须知道，这是个开源项目，每个 Contributor 和 Committer 没有义务回答问题
	 * 所以，最好你能翻墙
		
	 
	 
