#title: 使用 index.xml 作为索引文件
#index:0,1
#author: zozoh(zozohtnt@gmail.com)
--------------------------------------------------------------------------------------------

关于 index.xml
	为什么需要索引文件
		通常，你会将你的很多 zDoc 文件分门别类的放在某个目录下。然后你有可能：
		 # 将这个目录全部输出到另外一个目录下
			 * 比较多的情况是输出成 HTML 格式的文档
		 # 将这个目录所有的 zDoc 文件合并到一个大的文档中去。
			* 可以是个大的 HTML
			* 更多的是个大的 PDF
		那么在 zDoc 转换程序组织这些文件时会碰到类似如下的问题：
			* 哪些文件需要转换？
			* 如果是 HTML 格式的目录转换，索引是什么？
			* 如果是合并成一个大文件，大文件都有哪些章节，顺序如何？

		所以在根目录放置一个 {*index.xml}，zDoc 转换程序就有办法获得充足的信息.

	为什么要用 XML 格式
		 * 我不假定使用 zDoc 的人都是程序员
		 * 即使是程序员也不一定喜欢 JSON，非程序肯定不喜欢 JSON，因为他们不喜欢很多的 `{` 和 `}`
		 * XML 有足够的灵活性和扩展空间
		 * XML 的结构化表现力很强
		 * 索引文件只有一份，XML 虽然麻烦一点，但是也不会很累

--------------------------------------------------------------------------------------------
index.xml 语法
	该文件的语法简单的令人发指
	 * 它只有一个元素 `<doc>`，
	 * `<doc>` 只有两个常用属性和两个不常用属性
	 * `<doc>` 可以嵌套

	index.xml 的格式如下:
	{{{<index.xml>
	<?xml version="1.0"?>
	<doc title="你的 Doc 文档名" author="作者名" index="目录级别">
		<doc path="根目录下的文档名称.zdoc" title="这个文档的标题"/>
		<doc path="目录名称" title="目录标题">
			<doc path="文档名称.zdoc"/>
		</doc>
	</doc>
	}}}
	举一个更详细的例子，比如你有一个如下的目录结构

	<ex01.png>

	那么在 index.xml 的内容应该为
	{{{<index.xml>
	<?xml version="1.0"?>
	<doc title="文档示例" author="zozoh(zozohtnt@gmail.com)" index="0,1">
		<doc path="preface.zdoc" title="前言"/>
		<doc path="part1" title="第一部分">
			<doc path="overview.zdoc"/>
			<doc path="section1.zdoc"/>
		</doc>
	</doc>
	}}}
	 * 根元素 `<doc>` 对应到根目录 docroot，即，{*index.xml 所在的目录}。
	 * 在跟元素你可以用 @author 属性声明这篇文档的默认作者，。如果目录下的 zDoc 文档没有声明 #author，那么便被认为是默认作者所写。
	 * 属性 @index 的值符合 [syntax.man zDoc语法] 中的 {#0AA;*目录索引} 中的定义
	 * @path 属性表示当前对应的目录或者文件
		 * 如果是目录，需要有标题 ({#080;_ 通过属性@title声明})，如果没有声明  @title，则使用目录名称来代替
		 * 如果是文件，如果没有 @title 属性，则采用文档的 #title，详情惨参看 [syntax.man zDoc语法] {#0AA;*文档属性} 这一节。




