#title: 用json文件声明Aop切片
#author:wendal(wendal1985@gmail.com)
#index:0,1
--------------------------------------------------------------------------------------------------------
需使用的类

	* org.nutz.ioc.aop.config.impl.JsonAopConfigration

--------------------------------------------------------------------------------------------------------
看看一个示例的ioc配置文件

	配置示例:
	{{{<json>
	var ioc = {
		log : {
			type :'org.nutz.aop.interceptor.LoggingMethodInterceptor'
		},
		myMI : {
			type : 'org.nutz.ioc.aop.config.impl.MyMI'
		},
		pet2 : {
		type : "org.nutz.ioc.aop.config.impl.Pet2"
		},
		
		$aop : {
			type : 'org.nutz.ioc.aop.config.impl.JsonAopConfigration',
			fields : {
				itemList : [
					['.+','toString','ioc:log'],
					['.+','.+','ioc:myMI'],
					['.+','.+','org.nutz.ioc.aop.config.impl.MyMI2','false']
				]
			}
		}
	}
	}}}
	可以看到, 除了$aop这个beanName外,其他的与普通的ioc配置文件没有任何区别.
	
	$aop ,其实是org.nutz.ioc.aop.config.AopConfigration接口的IOCNAME字段的值,
	只有你声明这个名字,且类型为这个接口的实现,就能轻易的配置Ioc.
	
	估计你已经猜到,org.nutz.ioc.aop.config.impl.JsonAopConfigration就是其中一个实现!
	
	细看这个部分代码:
	{{{
			fields : {
				itemList : [
					['.+','toString','ioc:log'],
					['.+','.+','ioc:myMI'],
					['.+','.+','org.nutz.ioc.aop.config.impl.MyMI2','false']
				]
			}
	}}}
	
	使用JsonAopConfigration,只需要为其itemList赋值.
	
	需要什么值? 对,一个数组.
	
	数组的每一行,对应一条规则:
	{{{
	['.+','toString','ioc:log'],
	['.+','.+','ioc:myMI']
	['com\.wendal\.nutz\..+','get.+','org.nutz.ioc.aop.config.impl.MyMI2','false']
	}}}
	
	规则如下:
		* 第一个值,对应className,必选,用于匹配类的全称的正则表达式
		* 第二个值,对应methodName,必选,用于匹配方法名的正则表达式
		* 第三个值,对应interceptorName,必选,如果以ioc:开头,则代表对于ioc容器的一个对象,否则,将认为是一个类名
		* 第四个值,对应singleton,可选,仅当interceptorName为类名时有效
	
--------------------------------------------------------------------------------------------------------
拓展使用 -- 声明式事务

	首先,声明5种事务等级对应的拦截器(使用内置的事务拦截器 org.nutz.aop.interceptor.TransactionInterceptor)
	{{{
		txNONE : {
			type : 'org.nutz.aop.interceptor.TransactionInterceptor',
			args : [0]
		},
		txREAD_UNCOMMITTED : {
			type : 'org.nutz.aop.interceptor.TransactionInterceptor',
			args : [1]
		},
		txREAD_COMMITTED : {
			type : 'org.nutz.aop.interceptor.TransactionInterceptor',
			args : [2]
		},
		txREPEATABLE_READ : {
			type : 'org.nutz.aop.interceptor.TransactionInterceptor',
			args : [4]
		},
		txSERIALIZABLE : {
			type : 'org.nutz.aop.interceptor.TransactionInterceptor',
			args : [8]
		},
		//声明一个log进行日志记录
		log : {
			type :'org.nutz.aop.interceptor.LoggingMethodInterceptor'
		}
	}}}
	
	然后,定义哪些类的什么方法需要进行声明,继续添加 (一般来说,应该把等级高的往后放)
	{{{
		$aop : {
			type : 'org.nutz.ioc.aop.config.impl.JsonAopConfigration',
			fields : {
				itemList : [
					['com\\.service\\..+','.+','ioc:log'],
					['com\\.service\\.status\\..+','(get|set).+','ioc:txNONE'],
					['com\\.service\\.media\\..+','(get|set).+','ioc:txREAD_UNCOMMITTED'],
					['com\\.service\\.news\\..+','(get|set).+','ioc:txREAD_COMMITTED'],
					['com\\.service\\.blog\\..+','(get|save|update|delete).+','ioc:txREPEATABLE_READ'],
					['com\\.service\\.auth\\..+','.+','ioc:txSERIALIZABLE']
				]
			}
		}
	}}}
	
	按照上述声明:
	
		* 对于com.service包下的类的全部方法,均应用log拦截器
		* 对于com.service.status包下的类的全部get/set方法,均应用txNONE拦截器,事务级别 NONE
		* 对于com.service.media包下的类的全部get/set方法,均应用txREAD_UNCOMMITTED拦截器,事务级别 READ_UNCOMMITTED
		* 对于com.service.news包下的类的全部get/set方法,均应用txREPEATABLE_READ拦截器,事务级别 READ_COMMITTED
		* 对于com.service.blog包下的类的全部get/set/update/delete方法,均应用txREPEATABLE_READ拦截器,事务级别 READ_REPEATABLE_READ
		* 对于com.service.auth包下的类的全部方法,均应用txSERIALIZABLE拦截器,事务级别 SERIALIZABLE
		
	是不是觉得很长很繁琐, 1.b.52开始提供一个简便的方式
	
	
	{{{
	@IocBy(type=ComboIocProvider.class,
        args={"*json","org/nutz/mvc/testapp/classes/ioc",
              "*anno","org.nutz.mvc.testapp.classes",
              "*tx" // 你只需要加上这一行,即可声明5种不同事务级别的拦截器.
              		// 而JsonAopConfigration由于是用户自行定义的部分,只能要求你写个配置文件了
		})
	public class MainModule {}
	
	// 演示aop事务
	@IocBean // 需要aop,那当然需要时ioc的bean
	public class UserService {
		@Inject Dao dao; // 注入NutDao实例,必须的,哈哈
	
		@Aop(TransAop.READ_COMMITTED) // TransAop里面定义5个产量,分别对应不同级别的事务拦截器
		public void add(User user) {
			dao.insert(user);
			dao.update(UserToken.class, Chain.make("xxx","xxx"), Cnd.where(.......);
		}
	}	
	}}}

--------------------------------------------------------------------------------------------------------
重要提醒 -- 与@Aop同时使用

	本小结在1.b.52开始,无需关注, 因为会自动添加AnnotationAopConfigration

	如果你既使用了@Aop注解,又配置了上述的声明式Aop,你需要ComboAopConfigration来整合两种配置,示例:
	{{{
	$aop : {
		type : 'org.nutz.ioc.aop.config.impl.ComboAopConfigration',
		fields : {
			aopConfigrations  : [
				{	type : 'org.nutz.ioc.aop.config.impl.JsonAopConfigration',
    				fields : {
        				itemList : [
	            			['com\\.service\\..+','.+','ioc:log'],
							['com\\.service\\.status\\..+','(get|set).+','ioc:txNONE'],
							['com\\.service\\.media\\..+','(get|set).+','ioc:txREAD_UNCOMMITTED'],
							['com\\.service\\.news\\..+','(get|set).+','ioc:txREAD_COMMITTED'],
							['com\\.service\\.blog\\..+','(get|save|update|delete).+','ioc:txREPEATABLE_READ'],
							['com\\.service\\.auth\\..+','.+','ioc:txSERIALIZABLE']
        				]
    				}
				},
				{	type : 'org.nutz.ioc.aop.config.impl.AnnotationAopConfigration'}
			]
		}
	}
	}}}
	
	同理,你也可以整合XML声明式Aop.不过,为避免不必要的麻烦,请勿在不同配置方式中对同一个方法添加同一个拦截器
	
--------------------------------------------------------------------------------------------------------
1.b.52版开始的新变化

	可以定义多个aop configure对象,而无需ComboAopConfigration, 只需要定义为$aop_XXX 其中XXX是你需要的名字即可.
	
	而且AnnotationAopConfigration总是自动添加的(最末尾)
	
	{{{
	{
	$aop_json : {
		type : 'org.nutz.ioc.aop.config.impl.JsonAopConfigration',
    	fields : {
			itemList : [
				['com\\.service\\..+','.+','ioc:log'],
				['com\\.service\\.status\\..+','(get|set).+','ioc:txNONE'],
				['com\\.service\\.media\\..+','(get|set).+','ioc:txREAD_UNCOMMITTED'],
				['com\\.service\\.news\\..+','(get|set).+','ioc:txREAD_COMMITTED'],
				['com\\.service\\.blog\\..+','(get|save|update|delete).+','ioc:txREPEATABLE_READ'],
				['com\\.service\\.auth\\..+','.+','ioc:txSERIALIZABLE']
        	]
    	}
	},
	$aop_cache : {
		type : "org.nutz.jcache.NutCacheAopConfigure" // 这个配置可以由NutCacheIocLoader自动加载.
													  // 写在这里只是为了演示用法
	}
	}}}
	