#title: Nutz Java code rules (V1.0)
#author:Peter.Tung(mastung@gmail.com)
#index:0,1
------------------------------------------------------------------------------------------
0. Rules of rules

	 # Each items should not be ambiguous, and could be executed.
	 # Two levels for items:
		 * rule - {#F00;*R}
		 * suggest - {#080;*S}
	 # All "Rule" items must be observed

------------------------------------------------------------------------------------------
1. Code format
	 # {#F00;*R}-Please use Eclipse code formatter: [https://github.com/nutzam/nutz/blob/master/doc/eclipse/nutz-eclipse-java-code-format-1.0.xml]
		 * get it from [https://raw.github.com/nutzam/nutz/master/doc/eclipse/nutz-eclipse-java-code-format-1.0.xml github]
	 # {#080;*S}-Non Eclipse users, please read above XML
		 * {/No official formatter provided for Non Eclipse users yet, waiting for contributers.}
------------------------------------------------------------------------------------------
2. Naming
	--------------------------------------------------------------------------------------
	2.1 Package
		 # {#F00;*R}-all are lowercase, 2 or less words.
			 # {#080;*S}-better to be 1 singular noun
		 # {#F00;*R}-all packages should be start as "org.nutz"
	--------------------------------------------------------------------------------------
	2.2 Class and Interface
		 # {#080;*S}-Noun
		 # {#F00;*R}-Title case all class and interface names.
		 # {#F00;*R}-Interface shouldn't be start or end with "I" or "IF". For example: IBookDao, BookDaoIF.
		 # {#F00;*R}-Abstract class name should start with "Abstract", Interface name should end with "Interface".
		 # {#F00;*R}-Exception class name should end with "Exception".
		 # {#F00;*R}-If the class instance is used only once, the name should end with "ing", like: Rendering
		 # {#F00;*R}-Class name should be as short as possible. But it's better not abbreviate name. Abbreviation could be only used for regular classes, like: org.nutz.dao.Cnd
			 * If your class name is too long, the IDE may wrap the content to new line automatically, it's not friendly.
		 # {#F00;*R}-Not to conflict with Java standard class name, like: Class, Object, String
			 * If you do so, it means you are scoffing at the existing ones.
			 * You force the user to distinguish the two Harry Potter.
		 # {#080;*S}-You can use weird names in the following cases -- {^But you have be sure that users could understand the names' meaning after they use them}
			 * Very useful classes
			 * Very special classes
			 * Private classes or inner classes
			 * Non recommended public, protected, default classes
				 * not to attract people's attention.
		 # {#F00;*R}-Default interface implementation should start with "Default". like: DefaultEntityMaker.
			 * Or end with "Impl"
	--------------------------------------------------------------------------------------
	2.3 Variable name
		 # {#080;*S}-Better to use singular nouns
		 # {#F00;*R}-To restrict the scope as possible as you can.
		 # {#F00;*R}-If it is collection or array, name it with plural nouns.
			 * Map pets is better than Map petMap
		 # {#F00;*R}-Don't use one chararactor，especially i. You can use index or cursor.
	--------------------------------------------------------------------------------------
	2.4 Constant name
		 # {#F00;*R}-Constant（with final） name should be all UPPERCASE and with "_", like： public final int MAX_VALUE = 30.
	--------------------------------------------------------------------------------------
	2.5 Local variable name
		 # {#F00;*R}-Local variable name is better used 1-2 chararactor, like StringBuilder sb
	--------------------------------------------------------------------------------------
	2.6 Function
		 # {#F00;*R}-except setter / getter, all other functions' names should use verbs
		 # {#080;*S}-You can use weird names in the following cases -- {^But you have be sure that users could understand the names' meaning after they use them}
			 # Very useful functions
			 # Very special functions
			 # private or default functions
		 # {#080;*S}-Support chain setter, and getter could be the same name as setter
			{{{<JAVA>
			// Setter
			public Pet name(String name){
				this.name = name;
				return this;
			}
			
			// Getter
			public String name(){
				return this.name;
			}
			}}}
------------------------------------------------------------------------------------------
3. Comment
	 # {#F00;*R}-Comment must be synchronized with code.
	 # {#F00;*R}-End first sentence with ".", "?" or "!". It will be added into index.
	 # {#F00;*R}-Use "<P>" to separate paragraphs.
	 # {#F00;*R}-Use "<H2>" to label each chapter titles.
	 # {#F00;*R}-Use "<BR>" to change new lines.
	 # {#F00;*R}-Use "<PRE></PRE>" to wrap sample codes.

	--------------------------------------------------------------------------------------
	3.1  Class Java Doc 
		 # {#F00;*R}-Add author like: @Author XiaoMing(xm@gmail.com)
		 # {#F00;*R}-extended classes could be with no comments.
	--------------------------------------------------------------------------------------
	3.2  Function Java Doc 
		 # {#F00;*R}-Simple get/set functions could be with no comments.
		 # {#F00;*R}-extended functions could be with no comments.
	--------------------------------------------------------------------------------------
	3.3  Variable Java Doc 
		 * {#F00;*R}-see above
	--------------------------------------------------------------------------------------
	3.4  Comments in functions
		 * {#F00;*R}-accept comments or block comments
		 * {#F00;*R}-Not to write java doc
		 * {#F00;*R}-Make as "//TODO:" to where you want to continue
		 * {#F00;*R}-Comments for if ... else .. should be：
			{{{
			// comments for case A
			if(xxxx){
				//TODO you code here
			}
			/*
			 * Multipline comments for case B
			 */
			else if(xxxxx){
				//TODO you code here
			}
			// comments for default case
			else{
				//TODO you code here
			}
			}}}
------------------------------------------------------------------------------------------
4. Coding
	 # {#F00;*R}-Each commits, should be compile passed
	 # {#F00;*R}-Each commits, should be JUnit passed
		 * Except special reasons -- like you want to share with others
	 # {#F00;*R}-Shorter code is always better than longer one
		 * The shorter means shorter in logic.
	 # {#F00;*R}-To short the code is huge contribute for Nutz
	 # {#F00;*R}-Avoid over design
		 * To make it work is always most important than others.
		 * While interfaces are extracted from classes, it means the features are fixed.
		 * Please follow《[http://blog.sina.com.cn/s/blog_4b19fa3701000720.html]》to design code
------------------------------------------------------------------------------------------
5. JUnit test
	 # {#F00;*R}-Usecase name "{#00F;*long name}" - use "_" to replace space
		 * easy to understand the purpose from the names
	 # {#F00;*R}-To cover interfaces and classes as much as possible by usecases.



	
	 