#title: Nutz version naming rules
#author:Peter.Tung(mastung@gmail.com)

Nutz's jar files follow the listed naming rules
	{{{
	nutz[.Module Name]-Main Version.Build Level.[Publish Version].jar
	}}}
	 # {*Module Name} : Optional, if not statement, it means that it includes all features.
	 # {*Main Version} : Increased from 1, It will be change only in case the huge code changes.
	 # {*Build Level} : {*a} alpha level, {*b} beta level, {*r} release level
		 * {*a} {#080;_alpha}: Interfaces are not stable, they may be changed when the new version release.
		 * {*b} {#080;_beta}: Interfaces are stable, they are compatible with the following beta release, until a new alpha version will be published.
		 * {*r} {#080;_release}: Interfaces are quite stable.
	 # {*Publish Version} : Increased from 1. It will be reset as 1 while the Main Version or Build Level is changed. 

	It means, let's suppose the public versions as below:
	
	{#080;*1.b.30} -> {#A00;*1.a.31} -> {#080;*1.b.32} -> {#080;*1.b.33} -> {#080;*1.b.34}

	 * 1.b.32 may not be compatible with 1.b.30
	 * 1.b.34 can be compatible with 1.b.33 and 1.b.32
	
You also need to know

	If you find nutz-1.a.20.jar and nutz.1.b.18.jar
	 * 1.a.20 is newer, since its Publish Version is higher.
	 * 1.b.18 is more stable, it is compatible with previous beta releases
	 * The beta version after nutz-1.a.20.jar, will not be compatible 1.b.18, since the alpha release interrupt the continuity