package template

// RevisedTemplateTmpl defines the modified template proto with Type and InstanceParams
var RevisedTemplateTmpl = `// Copyright 2017 Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// THIS FILE IS AUTOMATICALLY GENERATED.

syntax = "proto3";

package {{.PackageName}};

import "mixer/v1/template/extensions.proto";
$$additional_imports$$

option (istio.mixer.v1.template.template_variety) = {{.VarietyName}};

{{.Comment}}
{{.TemplateMessage.Comment}}
message Type {
  {{range .TemplateMessage.Fields -}}
  {{- if valueTypeOrResMsg .ProtoType}}
  {{.Comment}}
  {{valueTypeOrResMsgFieldTypeName .ProtoType}} {{.ProtoName}} = {{.Number}};{{reportTypeUsed .ProtoType}}
  {{- end}}
  {{- end}}
}

{{range .ResourceMessages}}
{{.Comment}}
message {{getResourcMessageTypeName .Name}} {
  {{range .Fields}}
  {{- if valueTypeOrResMsg .ProtoType}}
  {{.Comment}}
  {{valueTypeOrResMsgFieldTypeName .ProtoType}} {{.ProtoName}} = {{.Number}};{{reportTypeUsed .ProtoType}}
  {{- end}}
  {{- end}}
}
{{end}}

message InstanceParam {
  {{range .TemplateMessage.Fields}}
  {{stringify .ProtoType}} {{.ProtoName}} = {{.Number}};
  {{end}}
}

{{range .ResourceMessages}}
message {{getResourcMessageInterfaceParamTypeName  .Name}} {
  {{range .Fields}}
  {{stringify .ProtoType}} {{.ProtoName}} = {{.Number}};
  {{end}}
}
{{end}}
`
