/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.errorprone.ErrorProneJavacJavaCompiler;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.scanner.BuiltInCheckerSuppliers;
import com.google.errorprone.scanner.ErrorProneScannerTransformer;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.util.Context;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class ErrorProneJavaCompiler
implements JavaCompiler {
    private final JavaCompiler javacTool;
    private final ScannerSupplier scannerSupplier;

    public ErrorProneJavaCompiler() {
        this(JavacTool.create());
    }

    ErrorProneJavaCompiler(JavaCompiler javacTool) {
        this(javacTool, BuiltInCheckerSuppliers.defaultChecks());
    }

    public ErrorProneJavaCompiler(ScannerSupplier scannerSupplier) {
        this(JavacTool.create(), scannerSupplier);
    }

    private ErrorProneJavaCompiler(JavaCompiler javacTool, ScannerSupplier scannerSupplier) {
        this.javacTool = javacTool;
        this.scannerSupplier = scannerSupplier;
    }

    @Override
    public JavaCompiler.CompilationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        Scanner scanner;
        ErrorProneOptions errorProneOptions;
        try {
            errorProneOptions = ErrorProneOptions.processArgs(options);
            scanner = (Scanner)this.scannerSupplier.applyOverrides(errorProneOptions).get();
        }
        catch (InvalidCommandLineOptionException e) {
            throw new RuntimeException(e);
        }
        ErrorProneScannerTransformer transformer = ErrorProneScannerTransformer.create(scanner);
        List<String> remainingOptions = Arrays.asList(errorProneOptions.getRemainingArgs());
        JavaCompiler.CompilationTask task = this.javacTool.getTask(out, fileManager, diagnosticListener, remainingOptions, classes, compilationUnits);
        Context context = ((JavacTaskImpl)task).getContext();
        ErrorProneJavacJavaCompiler.preRegister(context, transformer, errorProneOptions);
        return task;
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        return this.javacTool.getStandardFileManager(diagnosticListener, locale, charset);
    }

    @Override
    public int isSupportedOption(String option) {
        int numberOfArgs = this.javacTool.isSupportedOption(option);
        if (numberOfArgs != -1) {
            return numberOfArgs;
        }
        return ErrorProneOptions.isSupportedOption(option);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        return this.javacTool.run(in, out, err, arguments);
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        EnumSet<SourceVersion> filtered = EnumSet.noneOf(SourceVersion.class);
        for (SourceVersion version : this.javacTool.getSourceVersions()) {
            if (version.compareTo(SourceVersion.RELEASE_6) < 0) continue;
            filtered.add(version);
        }
        return filtered;
    }
}

