/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="ArrayHashCode", summary="hashcode method on array does not hash array contents", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class ArrayHashCode
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> varargsHashCodeMethodMatcher = Matchers.allOf(Matchers.anyOf(Matchers.staticMethod().onClass("com.google.common.base.Objects").named("hashCode"), Matchers.staticMethod().onClass("java.util.Objects").named("hash")), Matchers.hasArguments(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.isArrayType()));
    private static final Matcher<MethodInvocationTree> jdk7HashCodeMethodMatcher = Matchers.allOf(Matchers.staticMethod().onClass("java.util.Objects").named("hashCode"), Matchers.argument(0, Matchers.isArrayType()));
    private static final Matcher<ExpressionTree> instanceHashCodeMethodMatcher = Matchers.instanceMethod().onClass(TypePredicates.isArray()).named("hashCode");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        SuggestedFix.Builder fix = null;
        Types types = state.getTypes();
        if (jdk7HashCodeMethodMatcher.matches(tree, state)) {
            fix = SuggestedFix.builder().replace(tree, ArrayHashCode.rewriteArrayArgument(tree.getArguments().get(0), types));
        } else if (instanceHashCodeMethodMatcher.matches(tree, state)) {
            fix = SuggestedFix.builder().replace(tree, ArrayHashCode.rewriteArrayArgument(((JCTree.JCFieldAccess)tree.getMethodSelect()).getExpression(), types));
        } else if (varargsHashCodeMethodMatcher.matches(tree, state)) {
            if (tree.getArguments().size() == 1) {
                ExpressionTree arg = tree.getArguments().get(0);
                Type type = types.elemtype(ASTHelpers.getType(arg));
                if (type.isPrimitive() || types.isArray(type)) {
                    fix = SuggestedFix.builder().replace(tree, ArrayHashCode.rewriteArrayArgument(arg, types));
                }
            } else {
                fix = SuggestedFix.builder();
                for (ExpressionTree expressionTree : tree.getArguments()) {
                    if (!types.isArray(ASTHelpers.getType(expressionTree))) continue;
                    fix.replace(expressionTree, ArrayHashCode.rewriteArrayArgument(expressionTree, types));
                }
            }
        }
        if (fix != null) {
            fix.addImport("java.util.Arrays");
            return this.describeMatch(tree, fix.build());
        }
        return Description.NO_MATCH;
    }

    private static String rewriteArrayArgument(ExpressionTree arg, Types types) {
        Type argType = ASTHelpers.getType(arg);
        Preconditions.checkState((boolean)types.isArray(argType), (Object)"arg must be of array type");
        if (types.isArray(types.elemtype(argType))) {
            return "Arrays.deepHashCode(" + arg + ")";
        }
        return "Arrays.hashCode(" + arg + ")";
    }
}

