/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import javax.lang.model.type.TypeKind;

@BugPattern(name="ArraysAsListPrimitiveArray", summary="Arrays.asList does not autobox primitive arrays, as one might expect.", explanation="Arrays.asList does not autobox primitive arrays, as one might expect. If you intended to autobox the primitive array, use an asList method from Guava that does autobox.  If you intended to create a singleton list containing the primitive array, use Collections.singletonList to make your intent clearer.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class ArraysAsListPrimitiveArray
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> ARRAYS_AS_LIST_SINGLE_ARRAY = Matchers.allOf(Matchers.staticMethod().onClass("java.util.Arrays").named("asList"), Matchers.argumentCount(1), Matchers.argument(1, Matchers.isArrayType()));
    private static final Map<TypeKind, String> GUAVA_UTILS;

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (ARRAYS_AS_LIST_SINGLE_ARRAY.matches(tree, state)) {
            JCTree array = (JCTree)((Object)tree.getArguments().get(0));
            Type componentType = ((Type.ArrayType)array.type).getComponentType();
            String guavaUtils = GUAVA_UTILS.get((Object)componentType.getKind());
            if (guavaUtils != null) {
                Fix fix = SuggestedFix.builder().addImport("com.google.common.primitives." + guavaUtils).replace(tree.getMethodSelect(), guavaUtils + ".asList").build();
                return this.describeMatch(tree, fix);
            }
        }
        return Description.NO_MATCH;
    }

    static {
        EnumMap<TypeKind, String> guavaUtils = new EnumMap<TypeKind, String>(TypeKind.class);
        guavaUtils.put(TypeKind.BOOLEAN, "Booleans");
        guavaUtils.put(TypeKind.BYTE, "Bytes");
        guavaUtils.put(TypeKind.SHORT, "Shorts");
        guavaUtils.put(TypeKind.INT, "Ints");
        guavaUtils.put(TypeKind.LONG, "Longs");
        guavaUtils.put(TypeKind.CHAR, "Chars");
        guavaUtils.put(TypeKind.FLOAT, "Floats");
        guavaUtils.put(TypeKind.DOUBLE, "Doubles");
        GUAVA_UTILS = Collections.unmodifiableMap(guavaUtils);
    }
}

