/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import javax.lang.model.element.Modifier;

@BugPattern(name="ClassName", summary="The source file name should match the name of the top-level class it contains", explanation="Google Java Style Guide \u00a7 2.1 states, \"The source file name consists of the case-sensitive name of the top-level class it contains, plus the .java extension.\"", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class ClassName
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        if (tree.getTypeDecls().isEmpty() || tree.getPackageName() == null) {
            return Description.NO_MATCH;
        }
        String filename = Files.getNameWithoutExtension((String)tree.getSourceFile().getName());
        ArrayList<String> names = new ArrayList<String>();
        for (Tree tree2 : tree.getTypeDecls()) {
            if (!(tree2 instanceof ClassTree)) continue;
            ClassTree classMember = (ClassTree)tree2;
            if (classMember.getSimpleName().toString().equals(filename)) {
                return Description.NO_MATCH;
            }
            if (classMember.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) {
                return Description.NO_MATCH;
            }
            names.add(classMember.getSimpleName().toString());
        }
        String message = String.format("Expected a class declaration named %s inside %s.java, instead found: %s", filename, filename, Joiner.on((String)", ").join(names));
        return this.buildDescription(tree.getPackageName()).setMessage(message).build();
    }
}

