/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import javax.lang.model.element.ElementKind;

@BugPattern(name="EqualsHashCode", summary="Classes that override equals should also override hashCode.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.MATURE)
public class EqualsHashCode
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<MethodTree> EQUALS_MATCHER = Matchers.allOf(Matchers.methodIsNamed("equals"), Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC), Matchers.methodReturns(Suppliers.BOOLEAN_TYPE), Matchers.methodHasParameters(Matchers.variableType(Matchers.isSameType(Suppliers.OBJECT_TYPE))));

    @Override
    public Description matchClass(ClassTree classTree, VisitorState state) {
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol(classTree);
        if (((Symbol)symbol).getKind() != ElementKind.CLASS) {
            return Description.NO_MATCH;
        }
        MethodTree equals = null;
        for (Tree tree : classTree.getMembers()) {
            MethodTree methodTree;
            if (!(tree instanceof MethodTree) || !EQUALS_MATCHER.matches(methodTree = (MethodTree)tree, state)) continue;
            equals = methodTree;
        }
        if (equals == null) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol hashCodeSym = EqualsHashCode.resolveMethod(state, symbol, state.getName("hashCode"), (Iterable<Type>)ImmutableList.of(), (Iterable<Type>)ImmutableList.of());
        if (hashCodeSym.owner.equals(state.getSymtab().objectType.tsym)) {
            return this.describeMatch(equals);
        }
        return Description.NO_MATCH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Symbol.MethodSymbol resolveMethod(VisitorState state, Symbol.TypeSymbol base, Name name, Iterable<Type> argTypes, Iterable<Type> tyargTypes) {
        Resolve resolve = Resolve.instance(state.context);
        Enter enter = Enter.instance(state.context);
        Log log = Log.instance(state.context);
        Log.DeferredDiagnosticHandler handler = new Log.DeferredDiagnosticHandler(log);
        try {
            Symbol.MethodSymbol methodSymbol = resolve.resolveInternalMethod(null, enter.getEnv(base), base.type, name, List.from(argTypes), List.from(tyargTypes));
            return methodSymbol;
        }
        finally {
            log.popDiagnosticHandler(handler);
        }
    }
}

