/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

@BugPattern(name="ForOverride", summary="Method annotated @ForOverride must be protected or package-private and only invoked from declaring class", explanation="A method that overrides a @ForOverride method should not be invoked directly. Instead, it should be invoked only from the class in which it was declared. For example, if overriding Converter.doForward, you should invoke it through Converter.convert. For testing, factor out the code you want to run to a separate method.", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class ForOverrideChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MethodTreeMatcher {
    private static final String FOR_OVERRIDE = "com.google.errorprone.annotations.ForOverride";
    private static final String MESSAGE_BASE = "Method annotated @ForOverride ";
    private static final String GUAVA_FOR_OVERRIDE = "com.google.common.annotations.ForOverride";

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol method = ASTHelpers.getSymbol(tree);
        Type currentClass = this.getOutermostClass(state);
        if (method.isStatic() || method.isConstructor() || currentClass == null) {
            return Description.NO_MATCH;
        }
        List<Symbol.MethodSymbol> overriddenMethods = this.getOverriddenMethods(state, method);
        for (Symbol symbol : overriddenMethods) {
            TypeMirror declaringClass = symbol.outermostClass().asType();
            if (((Type)declaringClass).equals(currentClass)) continue;
            String customMessage = "Method annotated @ForOverride must not be invoked directly (except by the declaring class, " + declaringClass + ")";
            return this.buildDescription(tree).setMessage(customMessage).build();
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        List<Symbol.MethodSymbol> overriddenMethods;
        Symbol.MethodSymbol method = ASTHelpers.getSymbol(tree);
        if (method.isStatic() || method.isConstructor()) {
            return Description.NO_MATCH;
        }
        if ((method.getModifiers().contains((Object)Modifier.PUBLIC) || method.getModifiers().contains((Object)Modifier.PRIVATE)) && !(overriddenMethods = this.getOverriddenMethods(state, method)).isEmpty()) {
            String customMessage = "Method annotated @ForOverride must have protected or package-private visibility";
            return this.buildDescription(tree).setMessage(customMessage).build();
        }
        return Description.NO_MATCH;
    }

    private List<Symbol.MethodSymbol> getOverriddenMethods(VisitorState state, Symbol.MethodSymbol method) {
        if (method.isStatic()) {
            throw new IllegalArgumentException("getOverriddenMethods may not be called on a static method");
        }
        LinkedList<Symbol.MethodSymbol> list = new LinkedList<Symbol.MethodSymbol>();
        list.add(method);
        Type currType = state.getTypes().supertype(method.owner.type);
        while (currType != null && !currType.equals(state.getSymtab().objectType) && !currType.equals(Type.noType)) {
            Symbol sym = currType.tsym.members().findFirst(method.name);
            if (sym instanceof Symbol.MethodSymbol) {
                list.add((Symbol.MethodSymbol)sym);
            }
            currType = state.getTypes().supertype(currType);
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Symbol.MethodSymbol member = (Symbol.MethodSymbol)iter.next();
            if ((this.hasAnnotation(FOR_OVERRIDE, member) || this.hasAnnotation(GUAVA_FOR_OVERRIDE, member)) && method.overrides(member, (Symbol.TypeSymbol)member.owner, state.getTypes(), true)) continue;
            iter.remove();
        }
        return list;
    }

    private Type getOutermostClass(VisitorState state) {
        Type type = null;
        for (TreePath path = state.getPath(); path != null; path = path.getParentPath()) {
            if (path.getLeaf().getKind() != Tree.Kind.CLASS && path.getLeaf().getKind() != Tree.Kind.INTERFACE && path.getLeaf().getKind() != Tree.Kind.ENUM) continue;
            type = ASTHelpers.getSymbol((Tree)path.getLeaf()).type;
        }
        return type;
    }

    private boolean hasAnnotation(String annotation, Symbol member) {
        for (Attribute.Compound attribute : member.getAnnotationMirrors()) {
            if (!annotation.equals(attribute.type.toString())) continue;
            return true;
        }
        return false;
    }
}

