/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(name="GetClassOnClass", summary="Calling getClass() on an object of type Class returns the Class object for java.lang.Class; you probably meant to operate on the object directly", explanation="Calling `getClass()` on an object of type Class returns the Class object for java.lang.Class.  Usually this is a mistake, and people intend to operate on the object itself (for example, to print an error message).  If you really did intend to operate on the Class object for java.lang.Class, please use `Class.class` instead for clarity.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class GetClassOnClass
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> getClassMethodMatcher = Matchers.instanceMethod().onExactClass("java.lang.Class").named("getClass");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (getClassMethodMatcher.matches(tree, state)) {
            String methodInvoker = ASTHelpers.getReceiver(tree).toString();
            Fix removeGetClass = SuggestedFix.replace(tree, methodInvoker);
            Fix changeToClassDotClass = SuggestedFix.replace(tree, "Class.class");
            return this.buildDescription(tree).addFix(removeGetClass).addFix(changeToClassDotClass).build();
        }
        return Description.NO_MATCH;
    }
}

