/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@BugPattern(name="InjectScopeOrQualifierAnnotationRetention", summary="Scoping and qualifier annotations must have runtime retention.", explanation="The JSR-330 spec allows use of reflection. Not having runtime retention on scoping or qualifer annotations will cause unexpected behavior in frameworks that use reflection.", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class InjectScopeOrQualifierAnnotationRetention
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String GUICE_SCOPE_ANNOTATION = "com.google.inject.ScopeAnnotation";
    private static final String JAVAX_SCOPE_ANNOTATION = "javax.inject.Scope";
    private static final String GUICE_BINDING_ANNOTATION = "com.google.inject.BindingAnnotation";
    private static final String JAVAX_QUALIFER_ANNOTATION = "javax.inject.Qualifier";
    private static final String RETENTION_ANNOTATION = "java.lang.annotation.Retention";
    private static final Matcher<ClassTree> SCOPE_OR_QUALIFIER_ANNOTATION_MATCHER = Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.ScopeAnnotation"), Matchers.hasAnnotation("javax.inject.Scope"), Matchers.hasAnnotation("com.google.inject.BindingAnnotation"), Matchers.hasAnnotation("javax.inject.Qualifier"));

    @Override
    public final Description matchClass(ClassTree classTree, VisitorState state) {
        if ((ASTHelpers.getSymbol(classTree).flags() & 0x2000L) != 0L && SCOPE_OR_QUALIFIER_ANNOTATION_MATCHER.matches(classTree, state)) {
            Retention retention = ASTHelpers.getAnnotation(classTree, Retention.class);
            if (retention != null && retention.value().equals((Object)RetentionPolicy.RUNTIME)) {
                return Description.NO_MATCH;
            }
            return this.describe(classTree, state);
        }
        return Description.NO_MATCH;
    }

    public Description describe(ClassTree classTree, VisitorState state) {
        Retention retention = ASTHelpers.getAnnotation(classTree, Retention.class);
        if (retention == null) {
            return this.describeMatch(classTree, SuggestedFix.builder().addImport(RETENTION_ANNOTATION).addStaticImport("java.lang.annotation.RetentionPolicy.RUNTIME").prefixWith(classTree, "@Retention(RUNTIME)\n").build());
        }
        AnnotationTree retentionNode = null;
        for (AnnotationTree annotationTree : classTree.getModifiers().getAnnotations()) {
            if (!ASTHelpers.getSymbol(annotationTree).equals(state.getSymbolFromString(RETENTION_ANNOTATION))) continue;
            retentionNode = annotationTree;
        }
        return this.describeMatch(retentionNode, SuggestedFix.builder().addImport(RETENTION_ANNOTATION).addStaticImport("java.lang.annotation.RetentionPolicy.RUNTIME").replace(retentionNode, "@Retention(RUNTIME)").build());
    }
}

