/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.matchers.NextStatement;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.tools.javac.code.Symbol;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.lang.model.element.Name;

@BugPattern(name="MissingFail", altNames={"missing-fail"}, summary="Not calling fail() when expecting an exception masks bugs", category=BugPattern.Category.JUNIT, maturity=BugPattern.MaturityLevel.EXPERIMENTAL, severity=BugPattern.SeverityLevel.WARNING)
public class MissingFail
extends BugChecker
implements BugChecker.TryTreeMatcher {
    private static final Matcher<ExpressionTree> ASSERT_EQUALS = Matchers.anyOf(MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertEquals"), MethodMatchers.staticMethod().onClass("junit.framework.Assert").named("assertEquals"), MethodMatchers.staticMethod().onClass("junit.framework.TestCase").named("assertEquals"));
    private static final Matcher<Tree> ASSERT_UNEQUAL = Matchers.toType(MethodInvocationTree.class, new UnequalIntegerLiteralMatcher(ASSERT_EQUALS));
    private static final Matcher<ExpressionTree> ASSERT_TRUE = Matchers.anyOf(MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertTrue"), MethodMatchers.staticMethod().onClass("junit.framework.Assert").named("assertTrue"), MethodMatchers.staticMethod().onClass("junit.framework.TestCase").named("assertTrue"));
    private static final Matcher<ExpressionTree> ASSERT_FALSE = Matchers.anyOf(MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertFalse"), MethodMatchers.staticMethod().onClass("junit.framework.Assert").named("assertFalse"), MethodMatchers.staticMethod().onClass("junit.framework.TestCase").named("assertFalse"));
    private static final Matcher<ExpressionTree> ASSERT_TRUE_FALSE = Matchers.methodInvocation(ASSERT_TRUE, ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.booleanLiteral(false), Matchers.booleanConstant(false)));
    private static final Matcher<ExpressionTree> ASSERT_FALSE_TRUE = Matchers.methodInvocation(ASSERT_FALSE, ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.booleanLiteral(true), Matchers.booleanConstant(true)));
    private static final Matcher<ExpressionTree> ASSERT_TRUE_TRUE = Matchers.methodInvocation(ASSERT_TRUE, ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.booleanLiteral(true), Matchers.booleanConstant(true)));
    private static final Matcher<ExpressionTree> ASSERT_FALSE_FALSE = Matchers.methodInvocation(ASSERT_FALSE, ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.booleanLiteral(false), Matchers.booleanConstant(false)));
    private static final Matcher<StatementTree> JAVA_ASSERT_FALSE = Matchers.assertStatement(Matchers.ignoreParens(Matchers.anyOf(Matchers.booleanLiteral(false), Matchers.booleanConstant(false))));
    private static final Matcher<ExpressionTree> LOG_CALL = Matchers.methodInvocation(new LogMethodMatcher());
    private static final Matcher<Tree> LOG_IN_BLOCK = Matchers.contains(Matchers.toType(ExpressionTree.class, LOG_CALL));
    private static final Pattern FAIL_PATTERN = Pattern.compile(".*(?i:fail).*");
    private static final Matcher<ExpressionTree> FAIL = MethodMatchers.anyMethod().anyClass().withNameMatching(FAIL_PATTERN);
    private static final Matcher<ExpressionTree> ASSERT_CALL = Matchers.methodInvocation(new AssertMethodMatcher());
    private static final Matcher<ExpressionTree> REAL_ASSERT_CALL = Matchers.allOf(ASSERT_CALL, Matchers.not(Matchers.anyOf(ASSERT_FALSE_FALSE, ASSERT_TRUE_TRUE)));
    private static final Matcher<ExpressionTree> VERIFY_CALL = Matchers.methodInvocation(MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("verify"));
    private static final MultiMatcher<TryTree, Tree> ASSERT_LAST_CALL_IN_TRY = new ChildOfTryMatcher(ChildMultiMatcher.MatchType.LAST, Matchers.contains(Matchers.toType(ExpressionTree.class, Matchers.anyOf(REAL_ASSERT_CALL, VERIFY_CALL))));
    private static final Matcher<Tree> ASSERT_IN_BLOCK = Matchers.contains(Matchers.toType(ExpressionTree.class, REAL_ASSERT_CALL));
    private static final Matcher<StatementTree> THROW_STATEMENT = Matchers.throwStatement(Matchers.anything());
    private static final Matcher<Tree> THROW_OR_FAIL_IN_BLOCK = Matchers.contains(Matchers.anyOf(Matchers.toType(StatementTree.class, THROW_STATEMENT), Matchers.toType(ExpressionTree.class, ASSERT_TRUE_FALSE), Matchers.toType(ExpressionTree.class, ASSERT_FALSE_TRUE), Matchers.toType(ExpressionTree.class, ASSERT_UNEQUAL), Matchers.toType(StatementTree.class, JAVA_ASSERT_FALSE), Matchers.toType(ExpressionTree.class, FAIL)));
    private static final Matcher<TryTree> NON_TEST_METHOD = new IgnoredEnclosingMethodMatcher();
    private static final Matcher<Tree> RETURN_IN_BLOCK = Matchers.contains(Matchers.toType(StatementTree.class, Matchers.returnStatement(Matchers.anything())));
    private static final NextStatement<StatementTree> RETURN_AFTER = Matchers.nextStatement(Matchers.returnStatement(Matchers.anything()));
    private static final Matcher<VariableTree> INAPPLICABLE_EXCEPTION = Matchers.anyOf(Matchers.isSameType("java.lang.InterruptedException"), Matchers.isSameType("java.lang.AssertionError"), Matchers.isSameType("java.lang.Throwable"), Matchers.isSameType("junit.framework.AssertionFailedError"));
    private static final InLoopMatcher IN_LOOP = new InLoopMatcher();
    private static final Matcher<Tree> WHILE_TRUE_IN_BLOCK = Matchers.contains(Matchers.toType(WhileLoopTree.class, new WhileTrueLoopMatcher()));
    private static final Matcher<Tree> CONTINUE_IN_BLOCK = Matchers.contains(Matchers.toType(StatementTree.class, Matchers.continueStatement()));
    private static final Matcher<AssignmentTree> FIELD_ASSIGNMENT = Matchers.assignment(Matchers.isInstanceField(), Matchers.anything());
    private static final Matcher<Tree> FIELD_ASSIGNMENT_IN_BLOCK = Matchers.contains(Matchers.toType(AssignmentTree.class, FIELD_ASSIGNMENT));
    private static final Matcher<ExpressionTree> BOOLEAN_ASSERT_VAR = Matchers.methodInvocation(Matchers.anyOf(ASSERT_FALSE, ASSERT_TRUE), ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.isInstanceField(), Matchers.isVariable()));
    private static final Matcher<Tree> BOOLEAN_ASSERT_VAR_IN_BLOCK = Matchers.contains(Matchers.toType(ExpressionTree.class, BOOLEAN_ASSERT_VAR));
    private static final Matcher<ClassTree> JUNIT3_TEST_CLASS = Matchers.isSubtypeOf("junit.framework.TestCase");
    private static final Matcher<ClassTree> TEST_CLASS = Matchers.anyOf(JUNIT3_TEST_CLASS, new JUnitMatchers.JUnit4TestClassMatcher());

    @Override
    public Description matchTry(TryTree tree, VisitorState state) {
        if (this.tryTreeMatches(tree, state)) {
            List<? extends StatementTree> tryStatements = tree.getBlock().getStatements();
            StatementTree lastTryStatement = tryStatements.get(tryStatements.size() - 1);
            String failCall = String.format("%nfail(\"Expected %s\");", this.exceptionToString(tree));
            SuggestedFix.Builder fixBuilder = SuggestedFix.builder().postfixWith(lastTryStatement, failCall);
            fixBuilder.removeStaticImport("junit.framework.Assert.fail");
            fixBuilder.removeStaticImport("junit.framework.TestCase.fail");
            fixBuilder.addStaticImport("org.junit.Assert.fail");
            return this.describeMatch(lastTryStatement, fixBuilder.build());
        }
        return Description.NO_MATCH;
    }

    private String exceptionToString(TryTree tree) {
        if (tree.getCatches().size() != 1) {
            return "Exception";
        }
        String exceptionType = tree.getCatches().iterator().next().getParameter().getType().toString();
        if (exceptionType.contains("|")) {
            return "Exception";
        }
        return exceptionType;
    }

    private boolean tryTreeMatches(TryTree tree, VisitorState state) {
        if (!this.isInClass(tree, state, TEST_CLASS)) {
            return false;
        }
        boolean assertInCatch = this.hasAssertInCatch(tree, state);
        if (!this.hasExpectedException(tree) && !assertInCatch) {
            return false;
        }
        if (this.hasThrowOrFail(tree, state) || this.isInInapplicableMethod(tree, state) || this.returnsInTryCatchOrAfter(tree, state) || this.isInapplicableExceptionType(tree, state) || this.isInLoop(state, tree) || this.hasWhileTrue(tree, state) || this.hasContinue(tree, state) || this.hasFinally(tree) || this.logsInCatch(state, tree)) {
            return false;
        }
        return !assertInCatch || !this.hasFieldAssignmentInCatch(tree, state) && !this.hasBooleanAssertVariableInCatch(tree, state) && !this.lastTryStatementIsAssert(tree, state);
    }

    private boolean hasWhileTrue(TryTree tree, VisitorState state) {
        return WHILE_TRUE_IN_BLOCK.matches(tree, state);
    }

    private boolean isInClass(TryTree tree, VisitorState state, Matcher<ClassTree> classTree) {
        return Matchers.enclosingNode(Matchers.toType(ClassTree.class, classTree)).matches(tree, state);
    }

    private boolean hasBooleanAssertVariableInCatch(TryTree tree, VisitorState state) {
        return this.anyCatchBlockMatches(tree, state, BOOLEAN_ASSERT_VAR_IN_BLOCK);
    }

    private boolean lastTryStatementIsAssert(TryTree tree, VisitorState state) {
        return ASSERT_LAST_CALL_IN_TRY.matches(tree, state);
    }

    private boolean hasFieldAssignmentInCatch(TryTree tree, VisitorState state) {
        return this.anyCatchBlockMatches(tree, state, FIELD_ASSIGNMENT_IN_BLOCK);
    }

    private boolean logsInCatch(VisitorState state, TryTree tree) {
        return this.anyCatchBlockMatches(tree, state, LOG_IN_BLOCK);
    }

    private boolean hasFinally(TryTree tree) {
        return tree.getFinallyBlock() != null;
    }

    private boolean hasContinue(TryTree tree, VisitorState state) {
        return CONTINUE_IN_BLOCK.matches(tree, state);
    }

    private boolean isInLoop(VisitorState state, TryTree tree) {
        return IN_LOOP.matches(tree, state);
    }

    private boolean isInapplicableExceptionType(TryTree tree, VisitorState state) {
        for (CatchTree catchTree : tree.getCatches()) {
            if (!INAPPLICABLE_EXCEPTION.matches(catchTree.getParameter(), state)) continue;
            return true;
        }
        return false;
    }

    private boolean returnsInTryCatchOrAfter(TryTree tree, VisitorState state) {
        return RETURN_IN_BLOCK.matches(tree, state) || RETURN_AFTER.matches(tree, state);
    }

    private boolean isInInapplicableMethod(TryTree tree, VisitorState state) {
        return NON_TEST_METHOD.matches(tree, state);
    }

    private boolean hasThrowOrFail(TryTree tree, VisitorState state) {
        return THROW_OR_FAIL_IN_BLOCK.matches(tree, state);
    }

    private boolean hasAssertInCatch(TryTree tree, VisitorState state) {
        return this.anyCatchBlockMatches(tree, state, ASSERT_IN_BLOCK);
    }

    private boolean hasExpectedException(TryTree tree) {
        for (CatchTree catchTree : tree.getCatches()) {
            if (!catchTree.getParameter().getName().toString().equals("expected")) continue;
            return true;
        }
        return false;
    }

    private boolean anyCatchBlockMatches(TryTree tree, VisitorState state, Matcher<Tree> matcher) {
        for (CatchTree catchTree : tree.getCatches()) {
            if (!matcher.matches(catchTree.getBlock(), state)) continue;
            return true;
        }
        return false;
    }

    private static class ChildOfTryMatcher
    extends ChildMultiMatcher<TryTree, Tree> {
        public ChildOfTryMatcher(ChildMultiMatcher.MatchType matchType, Matcher<Tree> nodeMatcher) {
            super(matchType, nodeMatcher);
        }

        @Override
        protected Iterable<? extends StatementTree> getChildNodes(TryTree tree, VisitorState state) {
            return tree.getBlock().getStatements();
        }
    }

    private static class UnequalIntegerLiteralMatcher
    implements MultiMatcher<MethodInvocationTree, ExpressionTree> {
        private final Matcher<ExpressionTree> methodSelectMatcher;

        private UnequalIntegerLiteralMatcher(Matcher<ExpressionTree> methodSelectMatcher) {
            this.methodSelectMatcher = methodSelectMatcher;
        }

        @Override
        public boolean matches(MethodInvocationTree methodInvocationTree, VisitorState state) {
            return this.methodSelectMatcher.matches(methodInvocationTree, state) && this.matches(methodInvocationTree.getArguments());
        }

        private boolean matches(List<? extends ExpressionTree> expressionTrees) {
            HashSet<Integer> foundValues = new HashSet<Integer>();
            for (Tree tree : expressionTrees) {
                boolean duplicate;
                Object value;
                if (!(tree instanceof LiteralTree) || !((value = ((LiteralTree)tree).getValue()) instanceof Integer) || (duplicate = !foundValues.add((Integer)value)) || foundValues.size() <= 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public ExpressionTree getMatchingNode() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IgnoredEnclosingMethodMatcher
    implements Matcher<TryTree> {
        private IgnoredEnclosingMethodMatcher() {
        }

        @Override
        public boolean matches(TryTree tryTree, VisitorState state) {
            MethodTree enclosingMethodTree = ASTHelpers.findEnclosingNode(state.getPath(), MethodTree.class);
            Name name = enclosingMethodTree.getName();
            return JUnitMatchers.looksLikeJUnit3SetUp.matches(enclosingMethodTree, state) || JUnitMatchers.looksLikeJUnit3TearDown.matches(enclosingMethodTree, state) || name.contentEquals("main") || name.contentEquals("suite") || Matchers.hasAnnotation("org.junit.Before").matches(enclosingMethodTree, state) || Matchers.hasAnnotation("org.junit.After").matches(enclosingMethodTree, state);
        }
    }

    private static class WhileTrueLoopMatcher
    implements Matcher<WhileLoopTree> {
        private WhileTrueLoopMatcher() {
        }

        @Override
        public boolean matches(WhileLoopTree tree, VisitorState state) {
            return Matchers.ignoreParens(Matchers.booleanLiteral(true)).matches(tree.getCondition(), state);
        }
    }

    private static class InLoopMatcher
    implements Matcher<TryTree> {
        private InLoopMatcher() {
        }

        @Override
        public boolean matches(TryTree tryTree, VisitorState state) {
            return ASTHelpers.findEnclosingNode(state.getPath(), DoWhileLoopTree.class) != null || ASTHelpers.findEnclosingNode(state.getPath(), EnhancedForLoopTree.class) != null || ASTHelpers.findEnclosingNode(state.getPath(), WhileLoopTree.class) != null || ASTHelpers.findEnclosingNode(state.getPath(), ForLoopTree.class) != null;
        }
    }

    private static class LogMethodMatcher
    implements Matcher<ExpressionTree> {
        private LogMethodMatcher() {
        }

        @Override
        public boolean matches(ExpressionTree expressionTree, VisitorState state) {
            Symbol sym = ASTHelpers.getSymbol(expressionTree);
            if (sym != null && sym.getSimpleName().toString().startsWith("log")) {
                return true;
            }
            return sym != null && sym.isStatic() ? sym.owner.getQualifiedName().toString().contains("Logger") : expressionTree instanceof MemberSelectTree && ((MemberSelectTree)expressionTree).getExpression().toString().startsWith("log");
        }
    }

    private static class AssertMethodMatcher
    implements Matcher<ExpressionTree> {
        private AssertMethodMatcher() {
        }

        @Override
        public boolean matches(ExpressionTree expressionTree, VisitorState state) {
            Symbol sym = ASTHelpers.getSymbol(expressionTree);
            return sym != null && sym.getSimpleName().toString().startsWith("assert");
        }
    }
}

