/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;

@BugPattern(name="PrimitiveArrayPassedToVarargsMethod", summary="Passing a primitive array to a varargs method is usually wrong", explanation="When you pass a primitive array as the only argument to a varargs method, the primitive array is autoboxed into a single-element Object array. This is usually not what was intended.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class PrimitiveArrayPassedToVarargsMethod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> isVarargs = new Matcher<MethodInvocationTree>(){

        @Override
        public boolean matches(MethodInvocationTree t, VisitorState state) {
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(t);
            if (!(symbol instanceof Symbol.MethodSymbol)) {
                return false;
            }
            Symbol.MethodSymbol methodSymbol = symbol;
            if (!methodSymbol.isVarArgs()) {
                return false;
            }
            java.util.List params = methodSymbol.getParameters();
            int varargsPosition = ((List)params).length() - 1;
            Type.ArrayType varargsParamType = (Type.ArrayType)((Symbol.VarSymbol)((List)params).last()).type;
            JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)t;
            java.util.List arguments = methodInvocation.getArguments();
            Types types = state.getTypes();
            if (((List)arguments).size() != ((List)params).length()) {
                return false;
            }
            Type varargsArgumentType = ((JCTree.JCExpression)((List)arguments).get((int)varargsPosition)).type;
            if (!types.isArray(varargsArgumentType) || !types.elemtype(varargsArgumentType).isPrimitive()) {
                return false;
            }
            return !types.isSameType(varargsParamType, varargsArgumentType) && !types.isSameType(varargsParamType.getComponentType(), varargsArgumentType);
        }
    };

    @Override
    public Description matchMethodInvocation(MethodInvocationTree t, VisitorState state) {
        return isVarargs.matches(t, state) ? this.describeMatch(t) : Description.NO_MATCH;
    }
}

