/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.RequiredModifiers;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Names;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

@BugPattern(name="RequiredModifiers", summary="This annotation is missing required modifiers as specified by its @RequiredModifiers annotation", explanation="This annotation is itself annotated with @RequiredModifiers and can only be used when the specified modifiers are present. You are attempting touse it on an  element that is missing one or more required modifiers.", linkType=BugPattern.LinkType.NONE, category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.MATURE)
public class RequiredModifiersChecker
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final String MESSAGE_TEMPLATE = "%s has specified that it must be used together with the following modifiers: %s";
    private static final String GUAVA_ANNOTATION = "com.google.common.annotations.RequiredModifiers";
    private static final Function<Attribute.Enum, Modifier> TO_MODIFIER = new Function<Attribute.Enum, Modifier>(){

        public Modifier apply(Attribute.Enum input) {
            return Modifier.valueOf(input.getValue().name.toString());
        }
    };

    private static Set<Modifier> getRequiredModifiers(AnnotationTree tree, VisitorState state) {
        for (Attribute.Compound c : ASTHelpers.getSymbol(tree).getAnnotationMirrors()) {
            if (!((TypeElement)c.getAnnotationType().asElement()).getQualifiedName().contentEquals(GUAVA_ANNOTATION)) continue;
            List modifiers = (List)c.member(Names.instance((Context)state.context).value).getValue();
            return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)modifiers, TO_MODIFIER));
        }
        RequiredModifiers annotation = ASTHelpers.getAnnotation(tree, RequiredModifiers.class);
        if (annotation != null) {
            return ImmutableSet.copyOf((Object[])annotation.value());
        }
        return ImmutableSet.of();
    }

    @Override
    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        Set<Modifier> requiredModifiers = RequiredModifiersChecker.getRequiredModifiers(tree, state);
        if (requiredModifiers.isEmpty()) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof ModifiersTree)) {
            return Description.NO_MATCH;
        }
        Sets.SetView missing = Sets.difference(requiredModifiers, ((ModifiersTree)parent).getFlags());
        if (missing.isEmpty()) {
            return Description.NO_MATCH;
        }
        String annotationName = ASTHelpers.getAnnotationName(tree);
        String nameString = annotationName != null ? String.format("The annotation '@%s'", annotationName) : "This annotation";
        String customMessage = String.format(MESSAGE_TEMPLATE, nameString, missing.toString());
        return this.buildDescription(tree).setMessage(customMessage).build();
    }
}

