/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Var;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import java.util.Collections;
import java.util.EnumSet;
import javax.lang.model.element.Modifier;

@BugPattern(name="Var", summary="Non-constant variable missing @Var annotation", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class VarChecker
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final String UNNECESSARY_FINAL = "Unnecessary 'final' modifier.";

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol sym = ASTHelpers.getSymbol(tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation(sym, Var.class)) {
            return Description.NO_MATCH;
        }
        switch (((Symbol)sym).getKind()) {
            case PARAMETER: 
            case LOCAL_VARIABLE: {
                return this.handleLocalOrParam(tree, state, sym);
            }
            case FIELD: {
                return this.handleField(tree, sym);
            }
        }
        return Description.NO_MATCH;
    }

    private Description handleField(VariableTree tree, Symbol sym) {
        if ((sym.flags() & 0x10L) == 16L) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, VarChecker.addVarAnnotation(tree));
    }

    private Description handleLocalOrParam(VariableTree tree, VisitorState state, Symbol sym) {
        if (sym.getModifiers().contains((Object)Modifier.FINAL)) {
            if (Source.instance(state.context).allowEffectivelyFinalInInnerClasses()) {
                return this.buildDescription(tree).setMessage(UNNECESSARY_FINAL).addFix(SuggestedFix.removeModifier(tree, Modifier.FINAL, state)).build();
            }
            return Description.NO_MATCH;
        }
        if (!Collections.disjoint(sym.owner.getModifiers(), EnumSet.of(Modifier.ABSTRACT, Modifier.NATIVE))) {
            return Description.NO_MATCH;
        }
        if ((sym.flags() & 0x20000000010L) != 0L) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, VarChecker.addVarAnnotation(tree));
    }

    private static Fix addVarAnnotation(VariableTree tree) {
        return SuggestedFix.builder().prefixWith(tree, "@Var ").addImport(Var.class.getName()).build();
    }
}

