/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.io.Files;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.dataflow.nullnesspropagation.AbstractNullnessPropagationTransfer;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.VariableElement;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.cfg.CFGBuilder;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.EqualToNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NotEqualNode;
import org.checkerframework.dataflow.cfg.node.TypeCastNode;

class NullnessPropagationTransfer
extends AbstractNullnessPropagationTransfer
implements Serializable {
    private static final long serialVersionUID = -2413953917354086984L;
    private final transient Set<Symbol.VarSymbol> traversed = new HashSet<Symbol.VarSymbol>();
    private final Predicate<NullnessAnalysis.MethodInfo> methodReturnsNonNull;
    private transient Context context;
    private transient CompilationUnitTree compilationUnit;
    @VisibleForTesting
    static final ImmutableSet<String> CLASSES_WITH_NON_NULL_CONSTANTS = ImmutableSet.of((Object)BigInteger.class.getName(), (Object)BigDecimal.class.getName(), (Object)UnsignedInteger.class.getName(), (Object)UnsignedLong.class.getName(), (Object)StandardCharsets.class.getName());
    @VisibleForTesting
    static final ImmutableSetMultimap<MemberName, Integer> REQUIRED_NON_NULL_PARAMETERS = new ImmutableSetMultimap.Builder().put((Object)NullnessPropagationTransfer.member(Preconditions.class, "checkNotNull"), (Object)0).put((Object)NullnessPropagationTransfer.member(Verify.class, "verifyNotNull"), (Object)0).put((Object)NullnessPropagationTransfer.member("junit.framework.Assert", "assertNotNull"), (Object)-1).put((Object)NullnessPropagationTransfer.member("org.junit.Assert", "assertNotNull"), (Object)-1).build();
    @VisibleForTesting
    static final ImmutableSetMultimap<MemberName, Integer> NULL_IMPLIES_TRUE_PARAMETERS = new ImmutableSetMultimap.Builder().put((Object)NullnessPropagationTransfer.member(Strings.class, "isNullOrEmpty"), (Object)0).build();

    public NullnessPropagationTransfer() {
        this.methodReturnsNonNull = new ReturnValueIsNonNull();
    }

    public NullnessPropagationTransfer(Predicate<NullnessAnalysis.MethodInfo> additionalNonNullReturningMethods) {
        this.methodReturnsNonNull = Predicates.or((Predicate)new ReturnValueIsNonNull(), additionalNonNullReturningMethods);
    }

    NullnessPropagationTransfer setContext(@Nullable Context context) {
        Preconditions.checkArgument((context == null || this.context == null ? 1 : 0) != 0, (Object)"Context already set: reset after use and don't use this class concurrently");
        this.context = context;
        this.traversed.clear();
        return this;
    }

    NullnessPropagationTransfer setCompilationUnit(@Nullable CompilationUnitTree compilationUnit) {
        this.compilationUnit = compilationUnit;
        return this;
    }

    @Override
    Nullness visitValueLiteral() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitNullLiteral() {
        return Nullness.NULL;
    }

    @Override
    Nullness visitBitwiseOperation() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitNumericalComparison() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitNumericalOperation() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitTypeCast(TypeCastNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs) {
        return NullnessPropagationTransfer.hasPrimitiveType((Node)node) ? Nullness.NONNULL : inputs.valueOfSubNode(node.getOperand());
    }

    @Override
    Nullness visitStringConcatenate() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitNarrowingConversion() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitWideningConversion() {
        return Nullness.NONNULL;
    }

    @Override
    void visitEqualTo(EqualToNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.LocalVariableUpdates thenUpdates, AbstractNullnessPropagationTransfer.LocalVariableUpdates elseUpdates) {
        NullnessPropagationTransfer.handleEqualityComparison(true, node.getLeftOperand(), node.getRightOperand(), inputs, thenUpdates, elseUpdates);
    }

    @Override
    void visitNotEqual(NotEqualNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.LocalVariableUpdates thenUpdates, AbstractNullnessPropagationTransfer.LocalVariableUpdates elseUpdates) {
        NullnessPropagationTransfer.handleEqualityComparison(false, node.getLeftOperand(), node.getRightOperand(), inputs, thenUpdates, elseUpdates);
    }

    @Override
    Nullness visitAssignment(AssignmentNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.LocalVariableUpdates updates) {
        Nullness value = inputs.valueOfSubNode(node.getExpression());
        Node target = node.getTarget();
        if (target instanceof LocalVariableNode) {
            updates.set((LocalVariableNode)target, value);
        }
        if (target instanceof FieldAccessNode) {
            FieldAccessNode fieldAccess = (FieldAccessNode)target;
            ClassAndField targetField = NullnessPropagationTransfer.tryGetFieldSymbol(target.getTree());
            NullnessPropagationTransfer.setReceiverNullness(updates, fieldAccess.getReceiver(), targetField);
        }
        return value;
    }

    @Override
    Nullness visitLocalVariable(LocalVariableNode node, AbstractNullnessPropagationTransfer.LocalVariableValues values) {
        return NullnessPropagationTransfer.hasPrimitiveType((Node)node) || NullnessPropagationTransfer.hasNonNullConstantValue(node) ? Nullness.NONNULL : values.valueOfLocalVariable(node);
    }

    @Override
    Nullness visitFieldAccess(FieldAccessNode node, AbstractNullnessPropagationTransfer.LocalVariableUpdates updates) {
        ClassAndField accessed = NullnessPropagationTransfer.tryGetFieldSymbol(node.getTree());
        NullnessPropagationTransfer.setReceiverNullness(updates, node.getReceiver(), accessed);
        return this.fieldNullness(accessed);
    }

    @Override
    Nullness visitMethodInvocation(MethodInvocationNode node, AbstractNullnessPropagationTransfer.LocalVariableUpdates thenUpdates, AbstractNullnessPropagationTransfer.LocalVariableUpdates elseUpdates, AbstractNullnessPropagationTransfer.LocalVariableUpdates bothUpdates) {
        ClassAndMethod callee = NullnessPropagationTransfer.tryGetMethodSymbol(node.getTree());
        NullnessPropagationTransfer.setReceiverNullness(bothUpdates, node.getTarget().getReceiver(), callee);
        NullnessPropagationTransfer.setUnconditionalArgumentNullness(bothUpdates, node.getArguments(), callee);
        NullnessPropagationTransfer.setConditionalArgumentNullness(elseUpdates, node.getArguments(), callee);
        return this.returnValueNullness(callee);
    }

    @Override
    Nullness visitObjectCreation() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitArrayCreation(ArrayCreationNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.LocalVariableUpdates updates) {
        return Nullness.NONNULL;
    }

    private static void handleEqualityComparison(boolean equalTo, Node leftNode, Node rightNode, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.LocalVariableUpdates thenUpdates, AbstractNullnessPropagationTransfer.LocalVariableUpdates elseUpdates) {
        LocalVariableNode localVar;
        AbstractNullnessPropagationTransfer.LocalVariableUpdates notEqualBranchUpdates;
        Nullness leftVal = inputs.valueOfSubNode(leftNode);
        Nullness rightVal = inputs.valueOfSubNode(rightNode);
        Nullness equalBranchValue = leftVal.greatestLowerBound(rightVal);
        AbstractNullnessPropagationTransfer.LocalVariableUpdates equalBranchUpdates = equalTo ? thenUpdates : elseUpdates;
        AbstractNullnessPropagationTransfer.LocalVariableUpdates localVariableUpdates = notEqualBranchUpdates = equalTo ? elseUpdates : thenUpdates;
        if (leftNode instanceof LocalVariableNode) {
            localVar = (LocalVariableNode)leftNode;
            equalBranchUpdates.set(localVar, equalBranchValue);
            notEqualBranchUpdates.set(localVar, leftVal.greatestLowerBound(rightVal.deducedValueWhenNotEqual()));
        }
        if (rightNode instanceof LocalVariableNode) {
            localVar = (LocalVariableNode)rightNode;
            equalBranchUpdates.set(localVar, equalBranchValue);
            notEqualBranchUpdates.set(localVar, rightVal.greatestLowerBound(leftVal.deducedValueWhenNotEqual()));
        }
    }

    private static boolean hasPrimitiveType(Node node) {
        return node.getType().getKind().isPrimitive();
    }

    private static boolean hasNonNullConstantValue(LocalVariableNode node) {
        if (node.getElement() instanceof VariableElement) {
            VariableElement element = (VariableElement)node.getElement();
            return element.getConstantValue() != null;
        }
        return false;
    }

    private static ClassAndField tryGetFieldSymbol(Tree tree) {
        Symbol symbol = NullnessPropagationTransfer.tryGetSymbol(tree);
        if (symbol instanceof Symbol.VarSymbol) {
            return ClassAndField.make((Symbol.VarSymbol)symbol);
        }
        return null;
    }

    static ClassAndMethod tryGetMethodSymbol(MethodInvocationTree tree) {
        Symbol symbol = NullnessPropagationTransfer.tryGetSymbol(tree.getMethodSelect());
        if (symbol instanceof Symbol.MethodSymbol) {
            return ClassAndMethod.make((Symbol.MethodSymbol)symbol);
        }
        return null;
    }

    private static Symbol tryGetSymbol(Tree tree) {
        if (tree instanceof JCTree.JCIdent) {
            return ((JCTree.JCIdent)tree).sym;
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            return ((JCTree.JCFieldAccess)tree).sym;
        }
        return null;
    }

    private Nullness fieldNullness(@Nullable ClassAndField accessed) {
        if (accessed == null) {
            return Nullness.NULLABLE;
        }
        if (accessed.field.equals("class")) {
            return Nullness.NONNULL;
        }
        if (accessed.isEnumConstant()) {
            return Nullness.NONNULL;
        }
        if (accessed.isPrimitive()) {
            return Nullness.NONNULL;
        }
        if (accessed.hasNonNullConstantValue()) {
            return Nullness.NONNULL;
        }
        if (accessed.isStatic() && accessed.isFinal()) {
            if (CLASSES_WITH_NON_NULL_CONSTANTS.contains((Object)accessed.clazz)) {
                return Nullness.NONNULL;
            }
            Nullness initializer = this.fieldInitializerNullnessIfAvailable(accessed);
            if (initializer != null) {
                return initializer;
            }
        }
        return Nullness.NULLABLE;
    }

    private Nullness returnValueNullness(@Nullable ClassAndMethod callee) {
        if (callee == null) {
            return Nullness.NULLABLE;
        }
        return this.methodReturnsNonNull.apply((Object)callee) ? Nullness.NONNULL : Nullness.NULLABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Nullness fieldInitializerNullnessIfAvailable(ClassAndField accessed) {
        if (!this.traversed.add(accessed.symbol)) {
            return Nullness.NULL;
        }
        try {
            JavacProcessingEnvironment javacEnv = JavacProcessingEnvironment.instance(this.context);
            TreePath fieldDeclPath = Trees.instance(javacEnv).getPath(accessed.symbol);
            if (fieldDeclPath == null || fieldDeclPath.getCompilationUnit() != this.compilationUnit || !(fieldDeclPath.getLeaf() instanceof VariableTree)) {
                Nullness nullness = null;
                return nullness;
            }
            ExpressionTree initializer = ((VariableTree)fieldDeclPath.getLeaf()).getInitializer();
            if (initializer == null) {
                Nullness nullness = null;
                return nullness;
            }
            TreePath initializerPath = TreePath.getPath(fieldDeclPath, (Tree)initializer);
            UnderlyingAST.CFGStatement ast = new UnderlyingAST.CFGStatement(initializerPath.getLeaf());
            ControlFlowGraph cfg = CFGBuilder.build((TreePath)initializerPath, (ProcessingEnvironment)javacEnv, (UnderlyingAST)ast, (boolean)false, (boolean)false);
            Analysis analysis = new Analysis((ProcessingEnvironment)javacEnv, (TransferFunction)this);
            analysis.performAnalysis(cfg);
            Nullness nullness = (Nullness)analysis.getValue(initializerPath.getLeaf());
            return nullness;
        }
        finally {
            this.traversed.remove(accessed.symbol);
        }
    }

    private static void setReceiverNullness(AbstractNullnessPropagationTransfer.LocalVariableUpdates updates, Node receiver, Member member) {
        if (!member.isStatic() && receiver instanceof LocalVariableNode) {
            updates.set((LocalVariableNode)receiver, Nullness.NONNULL);
        }
    }

    private static void setUnconditionalArgumentNullness(AbstractNullnessPropagationTransfer.LocalVariableUpdates bothUpdates, List<Node> arguments, ClassAndMethod callee) {
        ImmutableSet requiredNonNullParameters = REQUIRED_NON_NULL_PARAMETERS.get((Object)callee.name());
        for (LocalVariableNode var : NullnessPropagationTransfer.variablesAtIndexes((Set<Integer>)requiredNonNullParameters, arguments)) {
            bothUpdates.set(var, Nullness.NONNULL);
        }
    }

    private static void setConditionalArgumentNullness(AbstractNullnessPropagationTransfer.LocalVariableUpdates elseUpdates, List<Node> arguments, ClassAndMethod callee) {
        ImmutableSet nullImpliesTrueParameters = NULL_IMPLIES_TRUE_PARAMETERS.get((Object)callee.name());
        for (LocalVariableNode var : NullnessPropagationTransfer.variablesAtIndexes((Set<Integer>)nullImpliesTrueParameters, arguments)) {
            elseUpdates.set(var, Nullness.NONNULL);
        }
    }

    private static Iterable<LocalVariableNode> variablesAtIndexes(Set<Integer> indexes, List<Node> arguments) {
        ArrayList<LocalVariableNode> result = new ArrayList<LocalVariableNode>();
        for (Integer i : indexes) {
            Node argument;
            if (i < 0) {
                i = arguments.size() + i;
            }
            if (i < 0 || i >= arguments.size() || !((argument = arguments.get(i)) instanceof LocalVariableNode)) continue;
            result.add((LocalVariableNode)argument);
        }
        return result;
    }

    private static MemberName member(Class<?> clazz, String member) {
        return NullnessPropagationTransfer.member(clazz.getName(), member);
    }

    private static MemberName member(String clazz, String member) {
        return new MemberName(clazz, member);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Preconditions.checkState((this.context == null ? 1 : 0) != 0, (Object)"Can't serialize while analyzing a method");
        Preconditions.checkState((this.compilationUnit == null ? 1 : 0) != 0, (Object)"Can't serialize while analyzing a method");
        out.defaultWriteObject();
    }

    static /* synthetic */ MemberName access$000(String x0, String x1) {
        return NullnessPropagationTransfer.member(x0, x1);
    }

    private static final class ClassAndField
    implements Member {
        final Symbol.VarSymbol symbol;
        final String clazz;
        final String field;

        private ClassAndField(Symbol.VarSymbol symbol) {
            this.symbol = symbol;
            this.clazz = symbol.owner.getQualifiedName().toString();
            this.field = ((Name)symbol.getSimpleName()).toString();
        }

        static ClassAndField make(Symbol.VarSymbol symbol) {
            return new ClassAndField(symbol);
        }

        @Override
        public boolean isStatic() {
            return this.symbol.isStatic();
        }

        public boolean isFinal() {
            return (this.symbol.flags() & 0x10L) == 16L;
        }

        public boolean isPrimitive() {
            return this.symbol.type.isPrimitive();
        }

        public boolean isEnumConstant() {
            return this.symbol.isEnum();
        }

        public boolean hasNonNullConstantValue() {
            return this.symbol.getConstValue() != null;
        }
    }

    static final class ClassAndMethod
    implements Member,
    NullnessAnalysis.MethodInfo {
        final String clazz;
        final String method;
        final List<String> annotations;
        final boolean isStatic;
        final boolean isPrimitive;
        final boolean isBoolean;

        private ClassAndMethod(String clazz, String method, List<String> annotations, boolean isStatic, boolean isPrimitive, boolean isBoolean) {
            this.clazz = clazz;
            this.method = method;
            this.annotations = ImmutableList.copyOf(annotations);
            this.isStatic = isStatic;
            this.isPrimitive = isPrimitive;
            this.isBoolean = isBoolean;
        }

        static ClassAndMethod make(Symbol.MethodSymbol symbol) {
            List annotationMirrors = symbol.getAnnotationMirrors();
            ArrayList<String> annotations = new ArrayList<String>(annotationMirrors.size());
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                annotations.add(annotationMirror.getAnnotationType().toString());
            }
            return new ClassAndMethod(symbol.owner.getQualifiedName().toString(), ((Name)symbol.getSimpleName()).toString(), annotations, symbol.isStatic(), symbol.getReturnType().isPrimitive(), symbol.getReturnType().getTag() == TypeTag.BOOLEAN);
        }

        @Override
        public boolean isStatic() {
            return this.isStatic;
        }

        MemberName name() {
            return new MemberName(this.clazz, this.method);
        }

        @Override
        public String clazz() {
            return this.clazz;
        }

        @Override
        public String method() {
            return this.method;
        }

        @Override
        public List<String> annotations() {
            return this.annotations;
        }

        @Override
        public boolean isPrimitive() {
            return this.isPrimitive;
        }
    }

    @VisibleForTesting
    static final class MemberName {
        final String clazz;
        final String member;

        MemberName(String clazz, String member) {
            this.clazz = clazz;
            this.member = member;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MemberName) {
                MemberName other = (MemberName)obj;
                return this.clazz.equals(other.clazz) && this.member.equals(other.member);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.member);
        }
    }

    static interface Member {
        public boolean isStatic();
    }

    private static class ReturnValueIsNonNull
    implements Predicate<NullnessAnalysis.MethodInfo>,
    Serializable {
        private static final long serialVersionUID = -6277529478866058532L;
        private static final ImmutableSet<MemberName> METHODS_WITH_NON_NULLABLE_RETURNS = ImmutableSet.of((Object)NullnessPropagationTransfer.access$000(Files.class.getName(), "toString"), (Object)NullnessPropagationTransfer.access$000(Class.class.getName(), "getName"), (Object)NullnessPropagationTransfer.access$000(Class.class.getName(), "getSimpleName"), (Object)NullnessPropagationTransfer.access$000(Class.class.getName(), "forName"), (Object)NullnessPropagationTransfer.access$000(Charset.class.getName(), "forName"));
        private static final ImmutableSet<String> CLASSES_WITH_NON_NULLABLE_RETURNS = ImmutableSet.of((Object)Optional.class.getName(), (Object)Preconditions.class.getName(), (Object)Verify.class.getName(), (Object)String.class.getName(), (Object)BigInteger.class.getName(), (Object)BigDecimal.class.getName(), (Object[])new String[]{UnsignedInteger.class.getName(), UnsignedLong.class.getName()});
        private static final ImmutableSet<String> CLASSES_WITH_NON_NULLABLE_VALUE_OF_METHODS = ImmutableSet.of((Object)Boolean.class.getName(), (Object)Byte.class.getName(), (Object)Character.class.getName(), (Object)Double.class.getName(), (Object)Float.class.getName(), (Object)Integer.class.getName(), (Object[])new String[]{Long.class.getName(), Short.class.getName(), Enum.class.getName(), String.class.getName()});

        private ReturnValueIsNonNull() {
        }

        public boolean apply(NullnessAnalysis.MethodInfo methodInfo) {
            for (String annotation : methodInfo.annotations()) {
                if (!annotation.endsWith("Nullable")) continue;
                return false;
            }
            if (methodInfo.method().equals("valueOf") && CLASSES_WITH_NON_NULLABLE_VALUE_OF_METHODS.contains((Object)methodInfo.clazz())) {
                return true;
            }
            if (methodInfo.isPrimitive()) {
                return true;
            }
            if (CLASSES_WITH_NON_NULLABLE_RETURNS.contains((Object)methodInfo.clazz())) {
                return true;
            }
            MemberName searchMemberName = new MemberName(methodInfo.clazz(), methodInfo.method());
            return METHODS_WITH_NON_NULLABLE_RETURNS.contains((Object)searchMemberName);
        }
    }
}

