/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.util.TreePath;

public class NullnessMatcher
implements Matcher<ExpressionTree> {
    private final NullnessAnalysis nullnessAnalysis;
    private final Nullness expectedNullnessValue;

    public NullnessMatcher(NullnessAnalysis nullnessAnalysis, Nullness expectedNullnessValue) {
        this.nullnessAnalysis = nullnessAnalysis;
        this.expectedNullnessValue = expectedNullnessValue;
    }

    @Override
    public boolean matches(ExpressionTree expr, VisitorState state) {
        TreePath exprPath = new TreePath(state.getPath(), expr);
        return this.nullnessAnalysis.getNullness(exprPath, state.context) == this.expectedNullnessValue;
    }
}

