/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.common.base.Optional;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.method.AbstractSimpleMatcher;
import com.google.errorprone.matchers.method.ConstructorClassMatcherImpl;
import com.google.errorprone.matchers.method.MatchState;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Supplier;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;

public class ConstructorMatcherImpl
extends AbstractSimpleMatcher<MatchState>
implements MethodMatchers.ConstructorMatcher {
    @Override
    protected Optional<MatchState> matchResult(ExpressionTree tree, VisitorState state) {
        try {
            if (!(tree instanceof JCTree.JCNewClass)) {
                return Optional.absent();
            }
            JCTree.JCNewClass newClass = (JCTree.JCNewClass)tree;
            Type clazz = newClass.constructor.getEnclosingElement().type;
            if (!(newClass.constructor instanceof Symbol.MethodSymbol)) {
                return Optional.absent();
            }
            Symbol.MethodSymbol sym = (Symbol.MethodSymbol)newClass.constructor;
            return Optional.of((Object)MatchState.create(clazz, sym));
        }
        catch (NullPointerException e) {
            return Optional.absent();
        }
    }

    @Override
    public MethodMatchers.ConstructorClassMatcher forClass(String className) {
        return new ConstructorClassMatcherImpl(this, TypePredicates.isExactType(className));
    }

    @Override
    public MethodMatchers.ConstructorClassMatcher forClass(Supplier<Type> classType) {
        return new ConstructorClassMatcherImpl(this, TypePredicates.isExactType(classType));
    }
}

