/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.client;

import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FactoryIdHelper;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableHook;
import com.hazelcast.ringbuffer.impl.client.AddAllRequest;
import com.hazelcast.ringbuffer.impl.client.AddAsyncRequest;
import com.hazelcast.ringbuffer.impl.client.AddRequest;
import com.hazelcast.ringbuffer.impl.client.CapacityRequest;
import com.hazelcast.ringbuffer.impl.client.HeadSequenceRequest;
import com.hazelcast.ringbuffer.impl.client.PortableReadResultSet;
import com.hazelcast.ringbuffer.impl.client.ReadManyRequest;
import com.hazelcast.ringbuffer.impl.client.ReadOneRequest;
import com.hazelcast.ringbuffer.impl.client.RemainingCapacityRequest;
import com.hazelcast.ringbuffer.impl.client.SizeRequest;
import com.hazelcast.ringbuffer.impl.client.TailSequenceRequest;
import java.util.Collection;

public class RingbufferPortableHook
implements PortableHook {
    public static final int F_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.portable.ringbuffer", -29);
    public static final int ADD_ALL = 1;
    public static final int ADD = 2;
    public static final int ADD_ASYNC = 3;
    public static final int CAPACITY = 4;
    public static final int HEAD_SEQUENCE = 5;
    public static final int READ_MANY = 6;
    public static final int READ_ONE = 7;
    public static final int REMAINING_CAPACITY = 8;
    public static final int SIZE = 9;
    public static final int TAIL_SEQUENCE = 10;
    public static final int READ_RESULT_SET = 11;

    @Override
    public int getFactoryId() {
        return F_ID;
    }

    @Override
    public PortableFactory createFactory() {
        return new PortableFactory(){

            @Override
            public Portable create(int classId) {
                switch (classId) {
                    case 1: {
                        return new AddAllRequest();
                    }
                    case 2: {
                        return new AddRequest();
                    }
                    case 3: {
                        return new AddAsyncRequest();
                    }
                    case 4: {
                        return new CapacityRequest();
                    }
                    case 5: {
                        return new HeadSequenceRequest();
                    }
                    case 6: {
                        return new ReadManyRequest();
                    }
                    case 7: {
                        return new ReadOneRequest();
                    }
                    case 8: {
                        return new RemainingCapacityRequest();
                    }
                    case 9: {
                        return new SizeRequest();
                    }
                    case 10: {
                        return new TailSequenceRequest();
                    }
                    case 11: {
                        return new PortableReadResultSet();
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Collection<ClassDefinition> getBuiltinDefinitions() {
        return null;
    }
}

