/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.monitoring.ProducerMonitor;
import java.util.Set;
import javax.inject.Provider;

public final class Producers {
    private static final AsyncFunction<Throwable, Produced<Object>> FUTURE_FALLBACK_FOR_PRODUCED = new AsyncFunction<Throwable, Produced<Object>>(){

        public ListenableFuture<Produced<Object>> apply(Throwable t) throws Exception {
            Produced produced = Produced.failed(t);
            return Futures.immediateFuture(produced);
        }
    };

    public static <T> ListenableFuture<Produced<T>> createFutureProduced(ListenableFuture<T> future) {
        return Futures.catchingAsync((ListenableFuture)Futures.transform(future, (Function)new Function<T, Produced<T>>(){

            public Produced<T> apply(T value) {
                return Produced.successful(value);
            }
        }), Throwable.class, Producers.futureFallbackForProduced());
    }

    private static <T> AsyncFunction<Throwable, Produced<T>> futureFallbackForProduced() {
        return FUTURE_FALLBACK_FOR_PRODUCED;
    }

    public static <T> ListenableFuture<Set<T>> createFutureSingletonSet(ListenableFuture<T> future) {
        return Futures.transform(future, (Function)new Function<T, Set<T>>(){

            public Set<T> apply(T value) {
                return ImmutableSet.of(value);
            }
        });
    }

    public static <T> Producer<T> producerFromProvider(final Provider<T> provider) {
        Preconditions.checkNotNull(provider);
        return new AbstractProducer<T>(){

            @Override
            protected ListenableFuture<T> compute(ProducerMonitor unusedMonitor) {
                return Futures.immediateFuture((Object)provider.get());
            }
        };
    }

    public static <T> Producer<T> immediateProducer(final T value) {
        return new Producer<T>(){

            @Override
            public ListenableFuture<T> get() {
                return Futures.immediateFuture((Object)value);
            }
        };
    }

    public static <T> Producer<T> immediateFailedProducer(final Throwable throwable) {
        return new Producer<T>(){

            @Override
            public ListenableFuture<T> get() {
                return Futures.immediateFailedFuture((Throwable)throwable);
            }
        };
    }

    private Producers() {
    }
}

