/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.BindingGraphValidator;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Formatter;
import dagger.shaded.auto.common.MoreElements;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor7;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class DependencyRequestFormatter
extends Formatter<DependencyRequest> {
    private final Types types;
    private final Elements elements;

    DependencyRequestFormatter(Types types, Elements elements) {
        this.types = types;
        this.elements = elements;
    }

    String toDependencyTrace(BindingGraphValidator.DependencyPath dependencyPath) {
        return Joiner.on((char)'\n').join((Iterable)dependencyPath.nonsyntheticRequests().transform((Function)this).filter(Predicates.not((Predicate)Predicates.equalTo((Object)""))).toList().reverse());
    }

    @Override
    public String format(DependencyRequest request) {
        return request.requestElement().accept(new ElementKindVisitor7<String, DependencyRequest>(){

            @Override
            public String visitExecutableAsMethod(ExecutableElement method, DependencyRequest request) {
                StringBuilder builder = new StringBuilder("    ");
                DependencyRequestFormatter.this.appendRequestedKeyAndVerb(builder, (Optional<AnnotationMirror>)request.key().qualifier(), request.key().type(), DependencyRequestFormatter.this.componentMethodRequestVerb(request));
                DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(method, builder);
                builder.append('(');
                for (VariableElement variableElement : method.getParameters()) {
                    builder.append(variableElement.getSimpleName());
                }
                builder.append(')');
                return builder.toString();
            }

            @Override
            public String visitVariableAsParameter(VariableElement variable, DependencyRequest request) {
                StringBuilder builder = new StringBuilder("    ");
                DependencyRequestFormatter.this.appendRequestedKeyAndVerb(request, builder);
                ExecutableElement methodOrConstructor = MoreElements.asExecutable(variable.getEnclosingElement());
                DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(methodOrConstructor, builder).append('(');
                int parameterIndex = methodOrConstructor.getParameters().indexOf(variable);
                if (parameterIndex > 0) {
                    builder.append("\u2026, ");
                }
                builder.append(variable.getSimpleName());
                if (parameterIndex < methodOrConstructor.getParameters().size() - 1) {
                    builder.append(", \u2026");
                }
                builder.append(')');
                return builder.toString();
            }

            @Override
            public String visitVariableAsField(VariableElement variable, DependencyRequest request) {
                StringBuilder builder = new StringBuilder("    ");
                DependencyRequestFormatter.this.appendRequestedKeyAndVerb(request, builder);
                DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(variable, builder);
                return builder.toString();
            }

            @Override
            public String visitType(TypeElement e, DependencyRequest request) {
                return "";
            }

            @Override
            protected String defaultAction(Element element, DependencyRequest request) {
                String string = String.valueOf((Object)element.getKind());
                String string2 = String.valueOf(element);
                throw new IllegalStateException(new StringBuilder(25 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid request ").append(string).append(" element ").append(string2).toString());
            }
        }, request);
    }

    private void appendRequestedKeyAndVerb(DependencyRequest request, StringBuilder builder) {
        this.appendRequestedKeyAndVerb(builder, request.key().qualifier(), this.requestedTypeWithFrameworkClass(request), "injected");
    }

    private void appendRequestedKeyAndVerb(StringBuilder builder, Optional<AnnotationMirror> qualifier, TypeMirror requestedType, String verb) {
        this.appendQualifiedType(builder, qualifier, requestedType);
        builder.append(" is ").append(verb).append(" at\n    ").append("    ");
    }

    private TypeMirror requestedTypeWithFrameworkClass(DependencyRequest request) {
        Optional<Class<?>> requestFrameworkClass = request.kind().frameworkClass;
        if (requestFrameworkClass.isPresent()) {
            return this.types.getDeclaredType(this.elements.getTypeElement(((Class)requestFrameworkClass.get()).getCanonicalName()), request.key().type());
        }
        return request.key().type();
    }

    private void appendQualifiedType(StringBuilder builder, Optional<AnnotationMirror> qualifier, TypeMirror type) {
        if (qualifier.isPresent()) {
            builder.append(qualifier.get()).append(' ');
        }
        builder.append(type);
    }

    private String componentMethodRequestVerb(DependencyRequest request) {
        switch (request.kind()) {
            case FUTURE: 
            case PRODUCER: {
                return "produced";
            }
            case INSTANCE: 
            case LAZY: 
            case PROVIDER: {
                return "provided";
            }
            case MEMBERS_INJECTOR: {
                return "injected";
            }
        }
        String string = String.valueOf(request);
        throw new AssertionError((Object)new StringBuilder(33 + String.valueOf(string).length()).append("illegal request kind for method: ").append(string).toString());
    }

    @CanIgnoreReturnValue
    private StringBuilder appendEnclosingTypeAndMemberName(Element member, StringBuilder builder) {
        TypeElement type = MoreElements.asType(member.getEnclosingElement());
        return builder.append(type.getQualifiedName()).append('.').append(member.getSimpleName());
    }
}

