/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ValidationReport;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

final class InjectFieldValidator {
    private CompilerOptions compilerOptions;

    public InjectFieldValidator(CompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    ValidationReport<VariableElement> validate(VariableElement fieldElement) {
        ImmutableSet<? extends AnnotationMirror> qualifiers;
        ValidationReport.Builder<VariableElement> builder = ValidationReport.about(fieldElement);
        Set<Modifier> modifiers = fieldElement.getModifiers();
        if (modifiers.contains((Object)Modifier.FINAL)) {
            builder.addError("@Inject fields may not be final", fieldElement);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private fields", this.compilerOptions.privateMemberValidationKind(), fieldElement);
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem("Dagger does not support injection into static fields", this.compilerOptions.staticMemberValidationKind(), fieldElement);
        }
        if ((qualifiers = InjectionAnnotations.getQualifiers(fieldElement)).size() > 1) {
            for (AnnotationMirror qualifier : qualifiers) {
                builder.addError("A single injection site may not use more than one @Qualifier.", fieldElement, qualifier);
            }
        }
        if (FrameworkTypes.isProducerType(fieldElement.asType())) {
            builder.addError(ErrorMessages.provisionMayNotDependOnProducerType(fieldElement.asType()), fieldElement);
        }
        return builder.build();
    }
}

