/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ValidationReport;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

final class InjectMethodValidator {
    private CompilerOptions compilerOptions;

    public InjectMethodValidator(CompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    ValidationReport<ExecutableElement> validate(ExecutableElement methodElement) {
        ValidationReport.Builder<ExecutableElement> builder = ValidationReport.about(methodElement);
        Set<Modifier> modifiers = methodElement.getModifiers();
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError("Methods with @Inject may not be abstract.", methodElement);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private methods", this.compilerOptions.privateMemberValidationKind(), methodElement);
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem("Dagger does not support injection into static methods", this.compilerOptions.staticMemberValidationKind(), methodElement);
        }
        if (!methodElement.getTypeParameters().isEmpty()) {
            builder.addError("Methods with @Inject may not declare type parameters.", methodElement);
        }
        for (VariableElement variableElement : methodElement.getParameters()) {
            ImmutableSet<? extends AnnotationMirror> qualifiers = InjectionAnnotations.getQualifiers(variableElement);
            if (qualifiers.size() > 1) {
                for (AnnotationMirror qualifier : qualifiers) {
                    builder.addError("A single injection site may not use more than one @Qualifier.", methodElement, qualifier);
                }
            }
            if (!FrameworkTypes.isProducerType(variableElement.asType())) continue;
            builder.addError(ErrorMessages.provisionMayNotDependOnProducerType(variableElement.asType()), variableElement);
        }
        return builder.build();
    }
}

