/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.SourceElement;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

final class KeyFormatter
extends Formatter<Key> {
    private final MethodSignatureFormatter methodSignatureFormatter;

    KeyFormatter(MethodSignatureFormatter methodSignatureFormatter) {
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    @Override
    public String format(Key request) {
        if (request.bindingMethod().isPresent()) {
            SourceElement bindingMethod = (SourceElement)request.bindingMethod().get();
            return this.methodSignatureFormatter.format(MoreElements.asExecutable(bindingMethod.element()), (Optional<DeclaredType>)Optional.of((Object)MoreTypes.asDeclared(((TypeElement)bindingMethod.contributedBy().get()).asType())));
        }
        StringBuilder builder = new StringBuilder();
        if (request.qualifier().isPresent()) {
            builder.append(request.qualifier().get());
            builder.append(' ');
        }
        builder.append(request.type());
        return builder.toString();
    }
}

