/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import dagger.internal.codegen.Key;
import java.util.Iterator;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;

enum KeyVariableNamer implements Function<Key, String>
{
    INSTANCE;


    public String apply(Key key) {
        StringBuilder builder = new StringBuilder();
        if (key.qualifier().isPresent()) {
            builder.append(((AnnotationMirror)key.qualifier().get()).getAnnotationType().asElement().getSimpleName());
        }
        key.type().accept(new SimpleTypeVisitor6<Void, StringBuilder>(){

            @Override
            public Void visitDeclared(DeclaredType t, StringBuilder builder) {
                builder.append(t.asElement().getSimpleName());
                Iterator<? extends TypeMirror> argumentIterator = t.getTypeArguments().iterator();
                if (argumentIterator.hasNext()) {
                    builder.append("Of");
                    TypeMirror first = argumentIterator.next();
                    first.accept(this, builder);
                    while (argumentIterator.hasNext()) {
                        builder.append("And");
                        argumentIterator.next().accept(this, builder);
                    }
                }
                return null;
            }
        }, builder);
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, builder.toString());
    }
}

