/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.ProvidesMethodValidator;
import dagger.internal.codegen.Validation;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class ProducesMethodValidator {
    private final Elements elements;
    private final Types types;

    ProducesMethodValidator(Elements elements, Types types) {
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        this.types = (Types)Preconditions.checkNotNull((Object)types);
    }

    private TypeElement getSetElement() {
        return this.elements.getTypeElement(Set.class.getCanonicalName());
    }

    ValidationReport<ExecutableElement> validate(ExecutableElement producesMethodElement) {
        TypeMirror returnType;
        TypeKind returnTypeKind;
        Set<Modifier> modifiers;
        ValidationReport.Builder<ExecutableElement> builder = ValidationReport.about(producesMethodElement);
        Element enclosingElement = producesMethodElement.getEnclosingElement();
        if (!MoreElements.isAnnotationPresent(enclosingElement, ProducerModule.class)) {
            builder.addError(this.formatModuleErrorMessage("@%s methods can only be present within a @%s"), producesMethodElement);
        }
        if (!producesMethodElement.getTypeParameters().isEmpty()) {
            builder.addError(this.formatErrorMessage("@%s methods may not have type parameters."), producesMethodElement);
        }
        if ((modifiers = producesMethodElement.getModifiers()).contains((Object)Modifier.PRIVATE)) {
            builder.addError(this.formatErrorMessage("@%s methods cannot be private"), producesMethodElement);
        }
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError(this.formatErrorMessage("@%s methods cannot be abstract"), producesMethodElement);
        }
        if (ConfigurationAnnotations.getNullableType(producesMethodElement).isPresent()) {
            builder.addWarning("@Nullable on @Produces methods does not do anything.", producesMethodElement);
        }
        if ((returnTypeKind = (returnType = producesMethodElement.getReturnType()).getKind()).equals((Object)TypeKind.VOID)) {
            builder.addError(this.formatErrorMessage("@%s methods must return a value (not void)."), producesMethodElement);
        }
        if (FrameworkTypes.isFrameworkType(returnType)) {
            builder.addError(this.formatErrorMessage("@%s methods must not return framework types."), producesMethodElement);
        }
        TypeMirror exceptionType = this.elements.getTypeElement(Exception.class.getCanonicalName()).asType();
        TypeMirror errorType = this.elements.getTypeElement(Error.class.getCanonicalName()).asType();
        for (TypeMirror typeMirror : producesMethodElement.getThrownTypes()) {
            if (this.types.isSubtype(typeMirror, exceptionType) || this.types.isSubtype(typeMirror, errorType)) continue;
            builder.addError("@Produces methods may only throw unchecked exceptions or exceptions subclassing Exception", producesMethodElement);
            break;
        }
        ContributionType contributionType = ContributionType.fromBindingMethod(producesMethodElement);
        ProvidesMethodValidator.validateMapKey(builder, producesMethodElement, contributionType, Produces.class);
        ProvidesMethodValidator.validateMultibindingSpecifiers(builder, producesMethodElement, Produces.class);
        Validation.validateMethodQualifiers(builder, producesMethodElement);
        block0 : switch (contributionType) {
            case UNIQUE: 
            case SET: {
                this.validateSingleReturnType(builder, returnType);
                break;
            }
            case MAP: {
                this.validateSingleReturnType(builder, returnType);
                ImmutableSet<? extends AnnotationMirror> immutableSet = MapKeys.getMapKeys(producesMethodElement);
                switch (immutableSet.size()) {
                    case 0: {
                        builder.addError(this.formatErrorMessage("@%s methods of type map must declare a map key"), producesMethodElement);
                        break block0;
                    }
                    case 1: {
                        break block0;
                    }
                }
                builder.addError(this.formatErrorMessage("@%s methods may not have more than one @MapKey-marked annotation"), producesMethodElement);
                break;
            }
            case SET_VALUES: {
                if (returnTypeKind.equals((Object)TypeKind.DECLARED) && MoreTypes.isTypeOf(ListenableFuture.class, returnType)) {
                    DeclaredType declaredReturnType = MoreTypes.asDeclared(returnType);
                    if (declaredReturnType.getTypeArguments().isEmpty()) break;
                    this.validateSetType(builder, (TypeMirror)Iterables.getOnlyElement(declaredReturnType.getTypeArguments()));
                    break;
                }
                this.validateSetType(builder, returnType);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return builder.build();
    }

    private String formatErrorMessage(String msg) {
        return String.format(msg, Produces.class.getSimpleName());
    }

    private String formatModuleErrorMessage(String msg) {
        return String.format(msg, Produces.class.getSimpleName(), ProducerModule.class.getSimpleName());
    }

    private void validateKeyType(ValidationReport.Builder<? extends Element> reportBuilder, TypeMirror type) {
        TypeKind kind = type.getKind();
        if (!(kind.isPrimitive() || kind.equals((Object)TypeKind.DECLARED) || kind.equals((Object)TypeKind.ARRAY))) {
            reportBuilder.addError("@Produces methods must either return a primitive, an array, a type variable, or a declared type, or a ListenableFuture of one of those types.", reportBuilder.getSubject());
        }
    }

    private void validateSingleReturnType(ValidationReport.Builder<? extends Element> reportBuilder, TypeMirror type) {
        if (type.getKind().equals((Object)TypeKind.DECLARED) && MoreTypes.isTypeOf(ListenableFuture.class, type)) {
            DeclaredType declaredType = MoreTypes.asDeclared(type);
            if (declaredType.getTypeArguments().isEmpty()) {
                reportBuilder.addError("@Produces methods cannot return a raw ListenableFuture.", reportBuilder.getSubject());
            } else {
                this.validateKeyType(reportBuilder, (TypeMirror)Iterables.getOnlyElement(declaredType.getTypeArguments()));
            }
        } else {
            this.validateKeyType(reportBuilder, type);
        }
    }

    private void validateSetType(ValidationReport.Builder<? extends Element> reportBuilder, TypeMirror type) {
        if (!type.getKind().equals((Object)TypeKind.DECLARED)) {
            reportBuilder.addError("@Produces methods of type set values must return a Set or ListenableFuture of Set", reportBuilder.getSubject());
            return;
        }
        DeclaredType declaredType = MoreTypes.asDeclared(type);
        if (!declaredType.asElement().equals(this.getSetElement())) {
            reportBuilder.addError("@Produces methods of type set values must return a Set or ListenableFuture of Set", reportBuilder.getSubject());
        } else if (declaredType.getTypeArguments().isEmpty()) {
            reportBuilder.addError(this.formatErrorMessage("@%s methods of type set values cannot return a raw Set"), reportBuilder.getSubject());
        } else {
            this.validateSingleReturnType(reportBuilder, (TypeMirror)Iterables.getOnlyElement(declaredType.getTypeArguments()));
        }
    }
}

