/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

final class SubjectUtils {
    SubjectUtils() {
    }

    static <T> List<T> accumulate(T first, T second, T ... rest) {
        ArrayList<T> items = new ArrayList<T>(2 + (rest == null ? 1 : rest.length));
        items.add(first);
        items.add(second);
        if (rest == null) {
            items.add(null);
        } else {
            items.addAll(Arrays.asList(rest));
        }
        return items;
    }

    static <T> int countOf(T t, Iterable<T> items) {
        int count = 0;
        for (T item : items) {
            if (!(t == null ? item == null : t.equals(item))) continue;
            ++count;
        }
        return count;
    }

    static <T> List<Object> countDuplicates(Collection<T> items) {
        ArrayList<T> itemSet = new ArrayList<T>();
        for (T item : items) {
            if (itemSet.contains(item)) continue;
            itemSet.add(item);
        }
        Object[] params = new Object[itemSet.size()];
        int n = 0;
        for (Object item : itemSet) {
            Object object;
            int count = SubjectUtils.countOf(item, items);
            int n2 = n++;
            if (count > 1) {
                String string = String.valueOf(item);
                object = new StringBuilder(21 + String.valueOf(string).length()).append(string).append(" [").append(count).append(" copies]").toString();
            } else {
                object = item;
            }
            params[n2] = object;
        }
        return Arrays.asList(params);
    }
}

