#ifndef TELIO_H
#define TELIO_H

/* Generated with cbindgen:0.24.3 */

/* Warning, this file is autogenerated by cbindgen. Don't modify this manually. */

#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>

/**
 * Possible adapters.
 */
typedef enum telio_adapter_type {
  /**
   * Userland rust implementation.
   */
  TELIO_ADAPTER_BORING_TUN,
  /**
   * Linux in-kernel WireGuard implementation
   */
  TELIO_ADAPTER_LINUX_NATIVE_TUN,
  /**
   * WireguardGo implementation
   */
  TELIO_ADAPTER_WIREGUARD_GO_TUN,
  /**
   * WindowsNativeWireguardNt implementation
   */
  TELIO_ADAPTER_WINDOWS_NATIVE_TUN,
} telio_adapter_type;

/**
 * Possible log levels.
 */
typedef enum telio_log_level {
  TELIO_LOG_CRITICAL = 1,
  TELIO_LOG_ERROR = 2,
  TELIO_LOG_WARNING = 3,
  TELIO_LOG_INFO = 4,
  TELIO_LOG_DEBUG = 5,
  TELIO_LOG_TRACE = 6,
} telio_log_level;

typedef enum telio_result {
  /**
   * Operation was successful.
   */
  TELIO_RES_OK = 0,
  /**
   * Operation resulted to unknown error.
   */
  TELIO_RES_ERROR = 1,
  /**
   * Cannot parse key as base64 string.
   */
  TELIO_RES_INVALID_KEY = 2,
  /**
   * Cannot parse configuration.
   */
  TELIO_RES_BAD_CONFIG = 3,
  /**
   * Cannot lock a mutex.
   */
  TELIO_RES_LOCK_ERROR = 4,
  /**
   * Cannot parse a string.
   */
  TELIO_RES_INVALID_STRING = 5,
  /**
   * The device is already started.
   */
  TELIO_RES_ALREADY_STARTED = 6,
} telio_result;

typedef void (*telio_event_fn)(void*, const char*);

/**
 * Event callback
 */
typedef struct telio_event_cb {
  /**
   * Context to pass to callback.
   * User must ensure safe access of this var from multithreaded context.
   */
  void *ctx;
  /**
   * Function to be called
   */
  telio_event_fn cb;
} telio_event_cb;

typedef void (*telio_logger_fn)(void*, enum telio_log_level, const char*);

/**
 * Logging callback
 */
typedef struct telio_logger_cb {
  /**
   * Context to pass to callback.
   * User must ensure safe access of this var from multithreaded context.
   */
  void *ctx;
  /**
   * Function to be called
   */
  telio_logger_fn cb;
} telio_logger_cb;

typedef void (*telio_protect_fn)(void*, int32_t);

/**
 * Android protect fd from VPN callback
 */
typedef struct telio_protect_cb {
  /**
   * Context to pass to callback.
   * User must ensure safe access of this var from multithreaded context.
   */
  void *ctx;
  /**
   * Function to be called
   */
  telio_protect_fn cb;
} telio_protect_cb;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

void __telio_force_export(enum telio_result,
                          enum telio_adapter_type,
                          struct telio_event_cb,
                          struct telio_logger_cb,
                          struct telio_protect_cb);

#ifdef __cplusplus
} // extern "C"
#endif // __cplusplus

#endif /* TELIO_H */
