# API Reference

Use the marimo library in marimo notebooks (`import marimo as mo`) to

- connect interactive inputs like sliders, dropdowns, and tables to Python,
- express yourself with dynamically created markdown,
- layout information with tabs or grids,
- output media like images and audio,
- and more!

|                      |                                                           |
| :------------------- | :-------------------------------------------------------- |
| [markdown](markdown.md)      | Write markdown with `mo.md`                               |
| [inputs](inputs/index.md)  | Connect sliders, dropdowns, tables, and more to Python    |
| [layouts](layouts/index.md) | Customize outputs with accordions, tabs, stacks, and more |
| [plotting](plotting.md)      | Output interactive plots                                  |
| [media](media/index.md)   | Output media like images, audio, PDFs, and plain text     |
| [diagrams](diagrams.md)      | Flow charts, graphs, statistic cards, and more            |
| [status](status.md)        | Display progress indicators                               |
| [outputs](outputs.md)       | Modify cell outputs, redirect console output              |
| [control_flow](control_flow.md)  | Control how cells execute                                 |
| [html](html.md)          | Manipulate HTML objects                                   |
| [query_params](query_params.md)  | Access and set query parameters with `mo.query_params`    |
| [cli_args](cli_args.md)      | Access command-line arguments with `mo.cli_args`          |
| [caching](caching.md)       | Cache expensive computations in memory or on disk         |
| [state](state.md)         | Synchronize multiple UI elements with `mo.state`          |
| [app](app.md)           | Embed notebooks in other notebooks                        |
| [cell](cell.md)          | Run cells defined in another notebook                     |
| [watch](watch.md)         | Reactively respond to file changes on disk          |
| [miscellaneous](miscellaneous.md) | Miscellaneous utilities                                   |
