package io.quarkus.mailer.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

import io.quarkus.mailer.Mail;
import io.quarkus.mailer.Mailer;
import io.quarkus.mailer.ReactiveMailer;

/**
 * Implementation of {@link Mailer} relying on the {@link ReactiveMailer} and waiting for completion.
 */
@ApplicationScoped
public class BlockingMailerImpl implements Mailer {

    @Inject
    ReactiveMailer mailer;

    @Override
    public void send(Mail... mails) {
        mailer.send(mails).toCompletableFuture().join();
    }
}
