---
title: Getting Started | C# Guide
description: Getting Started with C#
keywords: C#, Getting Started, Acquisition, Install
author: rpetrusha
ms.author: ronpet
ms.date: 08/23/2016
ms.topic: article
ms.prod: .net
ms.technology: devlang-csharp
ms.devlang: csharp
ms.assetid: b77c7263-7cbf-4729-9626-8fbc3f5f14d9
---

# Getting started with C# #

This section provides short, simple tutorials that let you quickly build an application using C# and .NET Core. There are getting started topics for Visual Studio 2017 and Visual Studio Code. You can build either a simple Hello World application or, if you have Visual Studio 2017, a simple class library that can be used by other applications.

The following topics are available:

- [Building a C# Hello World application with .NET Core in Visual Studio 2017](with-visual-studio-2017.md)

   Visual Studio 2017, the latest release of Visual Studio, lets you code, compile, run, debug, profile, and publish your applications from a integrated development environment for Windows.

   The topic lets you create and run a simple Hello World application and then modify it to run a slightly more interactive Hello World application. Once you've finished building and running your application, you can also learn how to [debug it](.\debugging-with-visual-studio-2017.md) and how to [publish it](.\publishing-with-visual-studio-2017.md) so that it can be run on any platform supported by .NET Core.

- [Building a class library with C# and .NET Core in Visual Studio 2017](library-with-visual-studio-2017.md)

   A class library lets you define types and type members that can be called from another application. This topic lets you create a class library with a single method that determines whether a string begins with an uppercase character. Once you've finished building the library, you can develop a [unit test](testing-library-with-visual-studio.md) to ensure that it works as expected, and then you can make it available to [applications that want to consume it](consuming-library-with-visual-studio-2017.md).

- [Getting started with Visual Studio Code](with-visual-studio-code.md)

   Visual Studio Code is a programming editor for Windows, Linux, and macOS that supports IntelliSense (code completion) and debugging.

   This topic shows you how to create and run a simple Hello World application with Visual Studio Code and .NET Core.