---
title: C# Guide
description: C# Guide
keywords: .NET, .NET Core
author: BillWagner

ms.date: 08/03/2016
ms.topic: article
ms.prod: .net
ms.technology: devlang-csharp
ms.devlang: csharp
ms.assetid: 52db8280-0e53-40cf-858b-e8eef3997dea
---

# C# Guide

The C# guide provides a wealth of information about the C# language. This site has many different audiences. Depending on your experience with programming, or with the C# language and .NET, you may wish to explore different sections of this guide.

* For brand-new developers:
    - Start with our [tutorials](tutorials/index.md) section. These tutorials show you how to create C# programs from scratch. The tutorials provide a step-by-step process to create programs. You'll learn the language concepts, and how to build C# programs on your own. If you prefer reading overview information first, try our [tour of the C# language](tour-of-csharp/index.md). It explains the concepts of the C# language. After reading this, you'll have a basic understanding of the language, and be ready to try the tutorials, or build something on your own.

* For developers new to C#: 
    - If you've done development before, but are new to C#, read the [tour of the C# language](tour-of-csharp/index.md). You will learn the basic syntax and structure for the language, and you can use the language tour to contrast C# with other languages you've used. You can also browse the [tutorials](tutorials/index.md) to try basic C# programs. Or, check out the [C# Concepts](concepts.md) to learn the features of the C# language in depth.

* Experienced C# developers:
    - If you've used C# before, you should start by reading what's in the latest version of the language. Check out [What's new in C# 6](csharp-6.md) for the new features in the current version. Then, explore the [C# Concepts](concepts.md) where you want more depth.
 
## How the C# guide is organized

There are seven sections in the C# Guide. You can read them in order, or jump directly to what interests you the most. Some of the sections are heavily focused on the language. Others provide end-to-end scenarios that demonstrate a few of the types of programs you can create using C# and the .NET Framework.

* [Getting Started](getting-started/index.md):
    - This section covers what you need to install for a C# development environment on your preferred platform. The different topics under this section explain how to create your first C# program in different supported environments.

* [Tutorials](tutorials/index.md):
    - This section provides a variety of end to end scenarios, including descriptions and code. You'll learn why certain idioms are preferred, what C# features work best in different situations, and see reference implemetntaions for common tasks. If you learn best by seeing code, start in this section. You can also download all the code and experiment in your own environment.

* [A Tour of C#](tour-of-csharp/index.md): 
    - This section provides an overview of the language. You'll learn the elements that make up C# programs and the capabilities of the language. You'll see small samples of all the syntax elements of C# and discussions of the major C# language topics. 

* [Latest Features](whats-new.md):
    - Learn about new features in the language. Learn about new tools like C# Interactive (C#'s REPL), and the .NET Compiler Platform SDK. You'll learn how the language is evolving. You'll see how the new tools can make you more productive in exploring the language, and automating tasks. 

* [C# Interactive](interactive/index.md):
    - C# Interactive is a Read-Eval-Print Loop (REPL) that you can use to interactively explore the language. It can also be used to explore different libraries and frameworks by trying different actions using an interactive approach. In this section you'll learn how to install and start C# interactive, and how to explore APIs with it. You'll also learn how to use C# interactive to export tested classes for later use.  

* [C# Concepts](concepts.md):
    - Learn the concepts that are most useful to C# programmers. This section contains several end to end scenarios that show you different techniques for C# development. It focuses on the language, but the nature of the end to end scenarios are that this section also includes several programs that demonstrate different frameworks and libraries that are part of the .NET ecosystem.

* [.NET Compiler Platform SDK](roslyn/index.md):
    - The .NET Compiler Platform SDK enables you to write components that analyze code, and suggest or make improvements to that code. In this section, you'll learn how the APIs are organized, and how you can create code that enables rules and practices for your team. You'll also see samples, end to end scenarios, and links to other libraries with more examples using these APIs.

* [Language Reference](language-reference/index.md):
    - This section contains the reference material on the C# language. This material will help you understand the syntax and semantics of C#. 
