---
title: "Compiler Error CS0038 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0038"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0038"
ms.assetid: ed378c79-c31b-4373-adfa-ee5dd2dccc9e
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0038
Cannot access a nonstatic member of outer type 'type1' via nested type 'type2'  
  
 A field in a class is not automatically available to a nested class. To be available to a nested class, the field must be [static](../../../csharp/language-reference/keywords/static.md). Otherwise, you must create an instance of the outer class. For more information, see [Nested Types](../../../csharp/programming-guide/classes-and-structs/nested-types.md).  
  
 The following sample generates CS0038:  
  
```  
// CS0038.cs  
class OuterClass  
{  
   public int count;  
   // try the following line instead  
   // public static int count;  
  
   class InnerClass  
   {  
      void func()  
      {  
         // or, create an instance  
         // OuterClass class_inst = new OuterClass();  
         // int count2 = class_inst.count;  
         int count2 = count;   // CS0038  
      }  
   }  
  
   public static void Main()  
   {  
   }  
}  
```