---
title: "Compiler Error CS0103 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0103"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0103"
ms.assetid: fd1f2104-a945-4dba-8137-8ef869826062
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0103
The name 'identifier' does not exist in the current context  
  
 An attempt was made to use a name that does not exist in the class, [namespace](../../../csharp/language-reference/keywords/namespace.md), or scope. Check the spelling of the name and check your using directives and assembly references to make sure that the name that you are trying to use is available.  
  
 This error frequently occurs if you declare a variable in a loop or a `try` or `if` block and then attempt to access it from an enclosing code block or a separate code block, as shown in the following example.  
  
```cs  
using System;  
  
class MyClass1  
{  
    public static void Main()  
    {  
        try  
        {  
            // The following declaration is only available inside the try block.  
            MyClass1 conn = new MyClass1();  
        }  
        catch (Exception e)  
        {  
            // The following expression causes error CS0103, because variable  
            // conn only exists in the try block.  
            if (conn != null)   
                Console.WriteLine("{0}", e);  
        }  
    }  
}  
  
```  
  
 The following example resolves the error.  
  
```cs  
  
using System;  
  
class MyClass2  
{  
    public static void Main()  
    {  
        // To resolve the error in the example, the first step is to   
        // move the declaration of conn out of the try block. The following  
        // declaration is available throughout the Main method.  
        MyClass2 conn = null;  
        try  
        {  
            // Inside the try block, use the conn variable that you declared  
            // previously.  
            conn = new MyClass2();  
        }  
        catch (Exception e)  
        {  
            // The following expression no longer causes an error, because  
            // the declaration of conn is in scope.  
            if (conn != null)   
                Console.WriteLine("{0}", e);  
        }  
    }  
}  
  
```