---
title: "Compiler Error CS0120 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0120"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0120"
ms.assetid: 3ff67f11-bdf9-436b-bc0c-4fa3cd1925a6
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0120
An object reference is required for the nonstatic field, method, or property 'member'  
  
 In order to use a non-static field, method, or property, you must first create an object instance. For more information about static methods, see [Static Classes and Static Class Members](../../../csharp/programming-guide/classes-and-structs/static-classes-and-static-class-members.md). For more information about creating instances of classes, see [Instance Constructors](../../../csharp/programming-guide/classes-and-structs/instance-constructors.md).  
  
 The following sample generates CS0120:  
  
```  
// CS0120_1.cs  
public class MyClass  
{  
   // Non-static field  
   public int i;   
   // Non-static method  
   public void f(){}  
   // Non-static property  
   int Prop  
   {  
      get   
      {  
         return 1;   
      }  
   }  
  
   public static void Main()  
   {  
      i = 10;   // CS0120  
      f();   // CS0120  
      int p = Prop;   // CS0120  
      // try the following lines instead  
      // MyClass mc = new MyClass();  
      // mc.i = 10;  
      // mc.f();  
      // int p = mc.Prop;  
   }  
}  
```  
  
 CS0120 will also be generated if there is a call to a non-static method from a static method, as follows:  
  
```  
// CS0120_2.cs  
// CS0120 expected  
using System;  
  
public class MyClass  
{  
   public static void Main()  
   {  
      TestCall();   // CS0120  
      // To call a non-static method from Main,  
      // first create an instance of the class.  
      // Use the following two lines instead:  
      // MyClass anInstanceofMyClass = new MyClass();  
      // anInstanceofMyClass.TestCall();  
   }  
  
   public void TestCall()  
   {  
   }  
}  
```  
  
 Similarly, a static method cannot call an instance method unless you explicitly give it an instance of the class, as follows:  
  
```  
// CS0120_3.cs  
using System;  
  
public class MyClass  
{  
   public static void Main()  
   {  
      do_it("Hello There");   // CS0120  
   }  
  
   private void do_it(string sText)  
   // You could also add the keyword static to the method definition:  
   // private static void do_it(string sText)  
   {  
      Console.WriteLine(sText);  
   }  
}  
```  
  
## See Also  
 [Classes and Structs](../../../csharp/programming-guide/classes-and-structs/index.md)