---
title: "Compiler Error CS0523 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0523"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0523"
ms.assetid: f91fb0ab-e1ef-4d6d-a3ef-5adc53a7e312
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0523
Struct member 'struct2 field' of type 'struct1' causes a cycle in the struct layout  
  
 The definitions of two structs include recursive references. Change the [struct](../../../csharp/language-reference/keywords/struct.md) definitions such that each does not define itself on the other. This limitation applies only to structs, since structs are value types. If using recursive references, declare your types as classes.  
  
 The following sample generates CS0523:  
  
```  
// CS0523.cs  
// compile with: /target:library  
struct RecursiveLayoutStruct1  
{  
   public RecursiveLayoutStruct2 field;  
}  
  
struct RecursiveLayoutStruct2  
{  
   public RecursiveLayoutStruct1 field;   // CS0523  
}  
```