---
title: "Compiler Error CS0545 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0545"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0545"
ms.assetid: f8c50376-76c4-46ac-9ee1-76cc58005cea
caps.latest.revision: 12
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0545
'function' : cannot override because 'property' does not have an overridable get accessor  
  
 A try was made to define an override for a property accessor when the base class has no such definition to override. You can resolve this error by:  
  
-   Adding a `set` accessor in the base class.  
  
-   Removing the `set` accessor from the derived class.  
  
-   Hiding the base class property by adding the [new](../../../csharp/language-reference/keywords/new.md) keyword to a property in a derived class.  
  
-   Making the base class property [virtual](../../../csharp/language-reference/keywords/virtual.md).  
  
 For more information, see [Using Properties](../../../csharp/programming-guide/classes-and-structs/using-properties.md).  
  
## Example  
 The following sample generates CS0545.  
  
```  
// CS0545.cs  
// compile with: /target:library  
// CS0545  
public class a  
{  
   public virtual int i  
   {  
      set {}  
  
      // Uncomment the following line to resolve.  
      // get { return 0; }  
   }  
}  
  
public class b : a  
{  
   public override int i  
   {  
      get { return 0; }  
      set {}   // OK  
   }  
}  
```