---
title: "Compiler Error CS1009 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1009"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1009"
ms.assetid: 348f500c-0e4f-44d7-95a8-e215ac49940a
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1009
Unrecognized escape sequence  
  
 An unexpected character follows a backslash (\\) in a [string](../../../csharp/language-reference/keywords/string.md). The compiler expects one of the valid escape characters. For more information, see [Character Escapes](http://msdn.microsoft.com/library/f49cc9cc-db7d-4058-8b8a-422bc08b29b0).  
  
 The following sample generates CS1009.  
  
```cs  
// CS1009-a.cs  
class MyClass  
{  
   static void Main()  
   {  
      // The following line causes CS1009.  
      string a = "\m";     
      // Try the following line instead.  
      // string a = "\t";  
   }  
}  
```  
  
 A common cause of this error is using the backslash character in a file name, as the following example shows.  
  
```cs  
string filename = "c:\myFolder\myFile.txt";  
```  
  
 To resolve this error, use "\\\\" or the @-quoted string literal, as the following example shows.  
  
```cs  
// CS1009-b.cs  
class MyClass  
{  
   static void Main()  
   {  
      // The following line causes CS1009.  
      string filename = "c:\myFolder\myFile.txt";     
      // Try one of the following lines instead.  
      // string filename = "c:\\myFolder\\myFile.txt";  
      // string filename = @"c:\myFolder\myFile.txt";  
   }  
}  
```  
  
## See Also  
 [string](../../../csharp/language-reference/keywords/string.md)