---
title: "Compiler Warning (level 1) CS1060 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1060"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1060"
ms.assetid: af389239-672b-449e-84b5-edb52e320013
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Warning (level 1) CS1060
Use of possibly unassigned field 'name'. Struct instance variables are initially unassigned if struct is unassigned.  
  
 Struct members are initialized to their default value if you do not explicitly initialize them. The default value for class types (and other reference types) is null. If the class is not initialized before any attempt to access it, a `NullReferenceException` will be thrown at runtime. The compiler cannot determine definitively whether the class member will be initialized or not, and so CS1060 is a warning and not an error.  
  
## To correct this error  
  
1.  Provide a constructor for the `struct` that initializes all its members.  
  
## Example  
 The following code generates CS1060 because the class type `U` is a member of the `struct S` but is never initialized.  
  
```  
// cs1060.cs  
namespace CS1060  
{      
    public class U  
    {  
        public int i;  
    }  
  
    public struct S  
    {  
        public U u;  
        // Add constructor to correct the error.  
        //public S(int val)  
        //{  
        //    u = new U() { i = val };  
        //}  
    }  
    public class Test  
    {  
        static void Main()  
        {  
            S s;  
            s.u.i = 5;  // CS1060  
  
            //Try these lines instead, and uncomment the constructor in S  
            // S s = new S(0);  
            // s.u.i = 5;  
  
        }  
    }    
}  
```  
  
## See Also  
 [Structs](../../../csharp/programming-guide/classes-and-structs/structs.md)