---
title: "Compiler Error CS1644 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1644"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1644"
ms.assetid: f51e2064-29e1-4a22-bbe3-577fa52df6bc
caps.latest.revision: 12
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1644
Feature 'feature' is not part of the standardized ISO C# language specification, and may not be accepted by other compilers  
  
 This error occurs if you specified the [/langversion](../../../csharp/language-reference/compiler-options/langversion-compiler-option.md) option ISO-1 and the code you are compiling uses features that are not part of the ISO 1.0 standard. To resolve this error, do not use any of the C# 2.0 compiler features such as generics or anonymous methods with the ISO-1 compatibility option.  
  
 The following sample generates CS1644:  
  
```  
// CS1644.cs  
// compile with: /langversion:ISO-1 /target:library  
class C<T> {}   // CS1644  
```