---
title: "Compiler Warning (level 1) CS1699 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1699"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1699"
ms.assetid: acf4b57d-8534-4417-9324-65415b5676ae
caps.latest.revision: 12
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Warning (level 1) CS1699
Use command line option "compiler_option" or appropriate project settings instead of "attribute_name"  
  
 In order to sign an assembly, it is necessary to specify a key file. Prior to [!INCLUDE[csprcsext](../../../csharp/language-reference/compiler-messages/includes/csprcsext_md.md)], you specified the key file using CLR attributes in source code. These attributes are now deprecated.  
  
 Beginning in [!INCLUDE[csprcsext](../../../csharp/language-reference/compiler-messages/includes/csprcsext_md.md)], you should use the **Signing Page** of the **Project Designer** or the Assembly Linker to specify the key file.  
  
 The **Signing Page** of the **Project Designer** is the preferred method; for more information, see [Signing Page, Project Designer](https://docs.microsoft.com/visualstudio/ide/reference/signing-page-project-designer) and [Managing Assembly and Manifest Signing](https://docs.microsoft.com/visualstudio/ide/managing-assembly-and-manifest-signing).  
  
 The [How to: Sign an Assembly with a Strong Name](http://msdn.microsoft.com/library/2c30799a-a826-46b4-a25d-c584027a6c67) uses the following compiler options:  
  
-   [/keyfile (C# Compiler Options)](../../../csharp/language-reference/compiler-options/keyfile-compiler-option.md) instead of the <xref:System.Reflection.AssemblyKeyFileAttribute> attribute.  
  
-   [/keycontainer (C# Compiler Options)](../../../csharp/language-reference/compiler-options/keycontainer-compiler-option.md) instead of<xref:System.Reflection.AssemblyKeyNameAttribute>.  
  
-   [/delaysign (C# Compiler Options)](../../../csharp/language-reference/compiler-options/delaysign-compiler-option.md) instead of <xref:System.Reflection.AssemblyDelaySignAttribute>.  
  
 These attributes have been deprecated for the following reasons:  
  
-   There were security issues due to the attributes being embedded in the binary files produced by the compiler. Everyone who had your binary also had the keys stored in it.  
  
-   There were usability issues due to the fact that the path specified in the attributes was relative to the current working directory, which could change in the integrated development environment (IDE), or to the output directory. Thus, most times the key file is likely to be ..\\\\..\\\mykey.snk. Attributes also make it more difficult for the project system to properly sign satellite assemblies. When you use the compiler options instead of these attributes, you can use a fully qualified path and file name for the key without anything being embedded in the output file; the project system and source code control system can properly manipulate that full path when projects are moved around; the project system can maintain a project-relative path to the key file, and still pass a full path to the compiler; other build programs can more easily sign outputs by passing the proper path directly to the compiler instead of generating a source file with the correct attributes.  
  
-   Using attributes with friend assemblies can hamper compiler efficiency. When you use attributes, the compiler does not know what the key is when it has to decide whether or not to grant friendship and so it has to guess. At the end of compilation, the compiler is able to verify the guess once it finally knows the key. When the key file is specified with a compiler option, the compiler can immediately decide whether to grant friendship.  
  
## Example  
 The following sample generates CS1699. To resolve the error, remove the attribute and compile with **/delaysign**.  
  
```  
// CS1699.cs  
// compile with: /target:library  
[assembly:System.Reflection.AssemblyDelaySign(true)]   // CS1699  
```  
  
## See Also  
 [Signing Page, Project Designer](https://docs.microsoft.com/visualstudio/ide/reference/signing-page-project-designer)   
 [Managing Assembly and Manifest Signing](https://docs.microsoft.com/visualstudio/ide/managing-assembly-and-manifest-signing)   
 [How to: Sign an Assembly with a Strong Name](http://msdn.microsoft.com/library/2c30799a-a826-46b4-a25d-c584027a6c67)