---
title: "Compiler Error CS1729 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1729"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1729"
ms.assetid: 69d24ae0-eaca-4fbf-a5f3-70791f43f97a
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1729
'type' does not contain a constructor that takes 'number' arguments.  
  
 This error occurs when you either directly or indirectly invoke the constructor of a class but the compiler cannot find any constructors with the same number of parameters. In the following example, the `test` class has no constructors that take any arguments. It therefore has only a default constructor that takes zero arguments. Because in the second line in which the error is generated, the derived class declares no constructors of its own, the compiler provides a default constructor. That constructor invokes a parameterless constructor in the base class. Because the base class has no such constructor, CS1729 is generated.  
  
## To correct this error  
  
1.  Adjust the number of parameters in the call to the constructor.  
  
2.  Modify the class to provide a constructor with the parameters you must call.  
  
3.  Provide a parameterless constructor in the base class.  
  
## Example  
 The following example generates CS1729:  
  
```cs  
// cs1729.cs  
class Test  
{  
    static int Main()  
    {  
        // Class Test has only a default constructor, which takes no arguments.  
        Test test1 = new Test(2); // CS1729  
        // The following line resolves the error.  
        Test test2 = new Test();  
  
        // Class Parent has only one constructor, which takes two int parameters.  
        Parent exampleParent1 = new Parent(10); // CS1729  
        // The following line resolves the error.  
        Parent exampleParent2 = new Parent(10, 1);  
  
        return 1;  
    }  
}  
  
public class Parent  
{  
    // The only constructor for this class has two parameters.  
    public Parent(int i, int j) { }  
}  
  
// The following declaration causes a compiler error because class Parent  
// does not have a constructor that takes no arguments. The declaration of  
// class Child2 shows how to resolve this error.  
public class Child : Parent { } // CS1729  
  
public class Child2 : Parent  
{  
    // The constructor for Child2 has only one parameter. To access the   
    // constructor in Parent, and prevent this compiler error, you must provide   
    // a value for the second parameter of Parent. The following example provides 0.  
    public Child2(int k)  
        : base(k, 0)  
    {  
        // Add the body of the constructor here.  
    }  
}  
```  
  
## See Also  
 [Inheritance](../../../csharp/programming-guide/classes-and-structs/inheritance.md)   
 [Constructors](../../../csharp/programming-guide/classes-and-structs/constructors.md)