---
title: "Compiler Warning (level 1) CS1762 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1762"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1762"
ms.assetid: 181d9063-e8a1-413d-8f0d-d05018642136
caps.latest.revision: 11
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Warning (level 1) CS1762
A reference was created to embedded interop assembly '\<assembly1>' because of an indirect reference to that assembly from assembly '\<assembly2>'. Consider changing the 'Embed Interop Types' property on either assembly.  
  
 You have added a reference to an assembly (assembly1) that has the `Embed Interop Types` property set to `True`. This instructs the compiler to embed interop type information from that assembly. However, the compiler cannot embed interop type information from that assembly because another assembly that you have referenced (assembly2) also references that assembly (assembly1) and has the `Embed Interop Types` property set to `False`.  
  
> [!NOTE]
>  Setting the `Embed Interop Types` property on an assembly reference to `True` is equivalent to referencing the assembly by using the `/link` option for the command-line compiler.  
  
### To address this warning  
  
-   To embed interop type information for both assemblies, set the `Embed Interop Types` property on all references to assembly1 to `True`. For more information about how to set that property, see [Walkthrough: Embedding Types from Managed Assemblies](http://msdn.microsoft.com/library/b28ec92c-1867-4847-95c0-61adfe095e21).  
  
-   To remove the warning, you can set the `Embed Interop Types` property of assembly1 to `False`. In this case, a primary interop assembly (PIA) provides interop type information.  
  
## See Also  
 [/link (C# Compiler Options)](../../../csharp/language-reference/compiler-options/link-compiler-option.md)   
 [Programming with Primary Interop Assemblies](http://msdn.microsoft.com/en-us/306fa1d6-0703-4004-9e93-d0a57f1be81e)