---
title: "C# Compiler Options | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
f1_keywords: 
  - "cs.build.options"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "compiler options [C#]"
  - "csc.exe"
  - "cl.exe compiler, C# options"
  - "Visual C# compiler"
  - "Visual C#, compiler options"
ms.assetid: d3403556-1816-4546-a782-e8223a772e44
caps.latest.revision: 21
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# C# Compiler Options
The compiler produces executable (.exe) files, dynamic-link libraries (.dll), or code modules (.netmodule).  
  
 Every compiler option is available in two forms: **-option** and **/option**. The documentation only shows the **/option** form.  
  
 In Visual Web Developer 2008, you set compiler options in the web.config file. For more information, see [\<compiler> Element](https://msdn.microsoft.com/library/y9x69bzw).  
  
## In This Section  
 [Command-line Building With csc.exe](../../../csharp/language-reference/compiler-options/command-line-building-with-csc-exe.md)  
 Information about building a Visual C# application from the command line.  
  
 [How to: Set Environment Variables for the Visual Studio Command Line](../../../csharp/language-reference/compiler-options/how-to-set-environment-variables-for-the-visual-studio-command-line.md)  
 Provides steps for running vsvars32.bat  to enable command-line builds.  
  
 [Deployment of C# Applications](../../../csharp/language-reference/compiler-options/app-deployment.md)  
 Describes options for deploying C# applications.  
  
 [C# Compiler Options Listed by Category](../../../csharp/language-reference/compiler-options/listed-by-category.md)  
 A categorical listing of the compiler options.  
  
 [C# Compiler Options Listed Alphabetically](../../../csharp/language-reference/compiler-options/listed-alphabetically.md)  
 An alphabetical listing of the compiler options.  
  
## Related Sections  
 [Build Page, Project Designer](https://docs.microsoft.com/visualstudio/ide/reference/build-page-project-designer-csharp)  
 Setting properties that govern how your project is compiled, built, and debugged. Includes information about custom build steps in Visual C# projects.  
  
 [Default and Custom Builds](https://docs.microsoft.com/visualstudio/ide/compiling-and-building-in-visual-studio)  
 Information on build types and configurations.  
  
 [Preparing and Managing Builds](https://docs.microsoft.com/visualstudio/ide/building-and-cleaning-projects-and-solutions-in-visual-studio)  
 Procedures for building within the Visual Studio development environment.