---
title: "C# Reference | Microsoft Docs"
ms.date: "2017-02-14"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "Visual C#, language reference"
  - "language reference [C#]"
  - "Programmer's Reference for C#"
  - "C# language, reference"
  - "reference, C# language"
ms.assetid: 06de3167-c16c-4e1a-b3c5-c27841d4569a
caps.latest.revision: 43
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# C# Reference
This section provides reference material about C# keywords, operators, special characters, preprocessor directives, compiler options, and compiler errors and warnings.  
  
## In This Section  
 [C# Keywords](../../csharp/language-reference/keywords/index.md)  
 Provides links to information about C# keywords and syntax.  
  
 [C# Operators](../../csharp/language-reference/operators/index.md)  
 Provides links to information about C# operators and syntax.  

 [C# Special Characters](../../csharp/language-reference/tokens/index.md)  
 Provides links to information about special contextual characters in C# and their usage.  

 [C# Preprocessor Directives](../../csharp/language-reference/preprocessor-directives/index.md)  
 Provides links to information about compiler commands for embedding in C# source code.  
  
 [C# Compiler Options](../../csharp/language-reference/compiler-options/index.md)  
 Includes information about compiler options and how to use them.  
  
 [C# Compiler Errors](../../csharp/language-reference/compiler-messages/index.md)  
 Includes code snippets that demonstrate the cause and correction of C# compiler errors and warnings.  
  
 [C# Language Specification](../../csharp/language-reference/language-specification.md)  
 Provides pointers to the latest version of the C# Language Specification in Microsoft Word format.  
  
## Related Sections  
 [C# FAQ](http://go.microsoft.com/fwlink/?LinkId=70367)  
 Provides a growing list of C# Frequently Asked Questions in the C# Developer Center.  
  
 [C# KB articles in the Microsoft Knowledge Base](http://go.microsoft.com/fwlink/?LinkId=70368)  
 Opens a Microsoft search page for Knowledge Base articles that are available on MSDN.  
  
 [C#](../../csharp/csharp.md)  
 Provides a portal to Visual C# documentation.  
  
 [Using the Visual Studio Development Environment for C#](https://docs.microsoft.com/visualstudio/csharp-ide/using-the-visual-studio-development-environment-for-csharp)  
 Provides links to conceptual and task topics that describe the IDE and Editor.  
  
 [C# Programming Guide](../../csharp/programming-guide/index.md)  
 Includes information about how to use the C# programming language.